% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_functions.R
\name{func.sum}
\alias{func.sum}
\title{Aggregate \code{survfit} object strata}
\usage{
func.sum(f1, f2, f1time, f2time)
}
\arguments{
\item{f1}{vector of cumulative-hazard estimates.}

\item{f2}{vector of cumulative-hazard estimates.}

\item{f1time}{vector of survival times for f1.}

\item{f2time}{vector of survival times for f2.}
}
\value{
A list of two numeric vectors.
}
\description{
\code{func.sum} calculates the sum and aggregate time points of two
cumulative-hazard functions or their variances, designed for use with
a \code{survfit} object having two strata.
}
\examples{
library(survival)
res <- summary(survfit(Surv(stop, event) ~ rx, data=bladder))
cols <- lapply(c(2:11) , function(x) res[x])
tbl <- do.call(data.frame, cols)
category = unique(tbl$strata)
temptbl1 = tbl[tbl$strata == category[1],]; temptbl1$n = res$n[1]
temptbl2 = tbl[tbl$strata == category[2],]; temptbl2$n = res$n[2]
sigma1_2 = cumhaz.var(temptbl1)
sigma2_2 = cumhaz.var(temptbl2)
func.sum(c(0, sigma1_2)/temptbl1$n[1], c(0, sigma2_2)/temptbl2$n[2],
  c(0, temptbl1$time), c(0, temptbl2$time))

}
\keyword{internal}
