% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizer.R
\name{validate_optimizer}
\alias{validate_optimizer}
\title{Validate \code{optimizer} object}
\usage{
validate_optimizer(
  x = new_optimizer(),
  .validate = FALSE,
  .validation_settings = list()
)
}
\arguments{
\item{x}{An object of class \code{optimizer}.}

\item{.validate}{A \code{logical}, set to \code{TRUE} (\code{FALSE}) to (not) validate the
\code{optimizer} object.
By default, \code{.validate = FALSE}.}

\item{.validation_settings}{Ignored if \code{.valdiate = FALSE}.
Otherwise, a \code{list} of validation settings:
\describe{
\item{objective_test}{A \code{function}, the test function to be optimized.
By default, it is the
\href{https://en.wikipedia.org/wiki/Ackley_function}{Ackley function}.}
\item{objective_add}{A \code{list} of additional arguments to
\code{objective_test} (if any).
By default, \code{objective_add = list()}, because the default function
for \code{objective_test} does not have additional arguments.}
\item{initial}{A \code{numeric} vector, the initial values for the
optimization of \code{objective_test}.
By default, \code{initial = round(stats::rnorm(2), 2)}.}
\item{check_seconds}{An \code{integer}, the maximum number of seconds
before the test is aborted.
The test call is considered to be successful if no error occurred
within \code{check_seconds} seconds.
By default, \code{check_seconds = 10}.}
}}
}
\value{
The validated input \code{x}.
}
\description{
This function validates an \code{optimizer} object.
}
\keyword{internal}
