% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_strat.R
\name{prop_strat}
\alias{prop_strat}
\title{Form propensity score strata}
\usage{
prop_strat(z, X, nstrata = 5)
}
\arguments{
\item{z}{Vector of treatment assignment}

\item{X}{Covariate matrix or data.frame}

\item{nstrata}{The number of strata to form}
}
\value{
Object of class "strat", which is a list containing \code{z},
\code{X} with the propensity score as an additional column, \code{base_strata}
(a factor of the resulting propensity score strata), and \code{details},
(a list containing \code{X_std}, which is the standardized version of the new \code{X})
}
\description{
Form initial propensity score strata
to be improved upon by \code{\link{refine}()}.
}
\examples{
 ps <- prop_strat(z = rhc_X[, "z"],
                  X = rhc_X[,  !(colnames(rhc_X) \%in\% c("pr", "z"))])
table(rhc_X[, "z"], ps$base_strata)
}
