% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.orbital_class}
\alias{predict.orbital_class}
\title{Prediction using orbital objects}
\usage{
\method{predict}{orbital_class}(object, new_data, ...)
}
\arguments{
\item{object}{An \link{orbital} object.}

\item{new_data}{A data frame or remote database table.}

\item{...}{Not currently used.}
}
\value{
A modified data frame or remote database table.
}
\description{
Running prediction on data frame of remote database table, without needing to
load original packages used to fit model.
}
\details{
Using this function should give identical results to running \code{predict()} or
\code{bake()} on the orginal object.

The prediction done will only return prediction colunms, a opposed to
returning all modified functions as done with \code{\link[=orbital_inline]{orbital_inline()}}.
}
\examples{
\dontshow{if (rlang::is_installed(c("recipes", "tidypredict", "workflows"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(workflows)
library(recipes)
library(parsnip)

rec_spec <- recipe(mpg ~ ., data = mtcars) \%>\%
  step_normalize(all_numeric_predictors())

lm_spec <- linear_reg()

wf_spec <- workflow(rec_spec, lm_spec)

wf_fit <- fit(wf_spec, mtcars)

orbital_obj <- orbital(wf_fit)

predict(orbital_obj, mtcars)
\dontshow{\}) # examplesIf}
}
