% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocmm.methods.R
\name{anova.ocmm}
\alias{anova.ocmm}
\title{Anova method for Continuous Ordinal Mixed Model Fits}
\usage{
\method{anova}{ocmm}(object, ...)
}
\arguments{
\item{object}{an \code{ocmm} object}

\item{...}{one or more additional \code{ocmm} objects}
}
\value{
An object of class \code{anova.ocmm} and \code{data.frame}, reporting for each model, in hierarchical order:
  \item{no.par}{number of parameters}
  \item{AIC}{Akaike information criterion}
  \item{loglik}{log-likelihood}
  \item{LR.stat}{likelihood ratio statistic}
  \item{df}{difference in the degrees of freedom in the models being compared}
  \item{Pr(>Chisq)}{p-value from the likelihood ratio test}
}
\description{
Comparison of continuous ordinal mixed models using likelihood ratio tests
}
\examples{
\dontrun{
fit.overall.rnd  <- ocmm(overall  ~ cycleno + bsa + treatment + (1|randno), data=ANZ0001)
anova(fit.overall.rnd, update(fit.overall.rnd, .~. + age))
}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\keyword{anova}

