% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-cmdscale-tidiers.r
\name{cmdscale_tidiers}
\alias{cmdscale_tidiers}
\alias{tidy.cmdscale}
\alias{glance.cmdscale}
\alias{tidy_cmdscale}
\alias{glance_cmdscale}
\title{Tidy \code{cmdscale()} list output}
\usage{
tidy_cmdscale(x, matrix = "points", ...)

glance_cmdscale(x, ...)
}
\arguments{
\item{x}{A list with components \code{points}, \code{eig}, \code{x}, \code{ac}, and \code{GOF} as
returned by \code{\link[stats:cmdscale]{stats::cmdscale()}}.}

\item{matrix}{Character specifying which list element should be tidied,
matched to the following options.
\itemize{
\item \code{"points"}: returns information about the coordinates in the
representation space.
\item \code{"x"}: returns information about the doubly-centered symmetric matrix
used in the calculation.
\item \code{"eig"}: returns information about the eigenvalues.
}}

\item{...}{Additional arguments allowed by generics; currently ignored.}
}
\value{
A \link[tibble:tibble]{tibble}.
}
\description{
These tidiers handle the output of \code{cmdscale()}, which under
certain conditions is effectively an S3 object without a class attribute.
It allows \strong{ordr} to enhance the \link{list_tidiers} provided by \strong{broom}.
}
\details{
When \code{\link[=cmdscale]{cmdscale()}} is instructed to return any of several optional elements,
or when \code{list. = TRUE}, the output is not the default point coordinate matrix
but a 5-element list with a consistent naming scheme (though some elements
will be \code{NULL} if their parameters are not set to \code{TRUE}). These tidiers rely
on this list structure to organize the model output into a tibble.
}
\examples{
# 'dist' object (matrix of road distances) of large American cities
class(UScitiesD)
print(UScitiesD)

# use multidimensional scaling to infer artificial planar coordinates
UScitiesD \%>\%
  cmdscale(k = 3L, eig = TRUE, x.ret = TRUE) ->
  usa_mds

# glance at the model
glance(usa_mds)
# return the tidied coordinates
tidy(usa_mds)
# return the upper triangle of the doubly-centered distance matrix in tidy form
tidy(usa_mds, matrix = "x")
# return the eigenvalues for the principal coordinates, with summary statistics
tidy(usa_mds, matrix = "eig")
# reorient to conventional compass
tidy(usa_mds) \%>\%
  ggplot(aes(x = -PCo1, y = -PCo2)) +
  geom_text(aes(label = point), size = 3) +
  ggtitle("MDS biplot of distances between U.S. cities")
}
\seealso{
\code{\link[generics:tidy]{generics::tidy()}} \code{\link[generics:glance]{generics::glance()}} \code{\link[stats:cmdscale]{stats::cmdscale()}}

Other list tidiers: 
\code{\link{cancor_tidiers}},
\code{\link{list_tidiers}}
}
\concept{list tidiers}
