% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-mass-mca.r
\name{methods-mca}
\alias{methods-mca}
\alias{as_tbl_ord.mca}
\alias{recover_rows.mca}
\alias{recover_cols.mca}
\alias{recover_inertia.mca}
\alias{recover_conference.mca}
\alias{recover_coord.mca}
\alias{recover_supp_rows.mca}
\alias{recover_aug_rows.mca}
\alias{recover_aug_cols.mca}
\alias{recover_aug_coord.mca}
\title{Functionality for multiple correspondence analysis ('mca') objects}
\usage{
\method{as_tbl_ord}{mca}(x)

\method{recover_rows}{mca}(x)

\method{recover_cols}{mca}(x)

\method{recover_inertia}{mca}(x)

\method{recover_conference}{mca}(x)

\method{recover_coord}{mca}(x)

\method{recover_supp_rows}{mca}(x)

\method{recover_aug_rows}{mca}(x)

\method{recover_aug_cols}{mca}(x)

\method{recover_aug_coord}{mca}(x)
}
\arguments{
\item{x}{An ordination object.}
}
\value{
The recovery generics \verb{recover_*()} return \link[=recoverers]{core model components}, \link[=conference]{distribution of inertia},
\link[=supplementation]{supplementary elements}, and \link[=augmentation]{intrinsic metadata}; but they require methods for each model class to
tell them what these components are.

The generic \code{\link[=as_tbl_ord]{as_tbl_ord()}} returns its input wrapped in the 'tbl_ord'
class. Its methods determine what model classes it is allowed to wrap. It
then provides 'tbl_ord' methods with access to the recoverers and hence to
the model components.
}
\description{
These methods extract data from, and attribute new data to,
objects of class \code{"mca"} from the \strong{\link[MASS:mca]{MASS}} package.
}
\details{
Multiple correspondence analysis (MCA) relies on a singular value
decomposition of the indicator matrix \eqn{X} of a table of several
categorical variables, scaled by its column totals. \code{\link[MASS:mca]{MASS::mca()}} returns the
SVD factors \eqn{UD} and \eqn{V} as the row weights \verb{$fs}, on which the
inertia is conferred, and the column coordinates \verb{$cs}. The row coordinates
\verb{$rs} are obtained as \eqn{XV} and accessible as supplementary elements.
}
\examples{
# table of admissions and rejections from UC Berkeley
class(UCBAdmissions)
ucb_admissions <- as.data.frame(UCBAdmissions)
ucb_admissions <-
  ucb_admissions[rep(seq(nrow(ucb_admissions)), ucb_admissions$Freq), -4L]
head(ucb_admissions)
# perform multiple correspondence analysis
ucb_admissions \%>\%
  MASS::mca() \%>\%
  as_tbl_ord() \%>\%
  # augment profiles with names, masses, distances, and inertias
  augment_ord() \%>\%
  print() -> admissions_mca

# recover row and column coordinates and row weights
head(get_rows(admissions_mca, elements = "score"))
get_cols(admissions_mca)
head(get_rows(admissions_mca))

# column-standard biplot of factor levels
admissions_mca \%>\%
  ggbiplot() +
  theme_bw() + theme_biplot() +
  geom_origin() +
  #geom_rows_point(stat = "unique") +
  geom_cols_point(aes(color = factor, shape = factor)) +
  geom_cols_text_repel(aes(label = level, color = factor),
                       show.legend = FALSE) +
  scale_color_brewer(palette = "Dark2") +
  scale_size_area(guide = "none") +
  labs(color = "Factor level", shape = "Factor level")
}
\seealso{
Other methods for singular value decomposition-based techniques: 
\code{\link{methods-cancor}},
\code{\link{methods-correspondence}},
\code{\link{methods-lda}},
\code{\link{methods-lra}},
\code{\link{methods-prcomp}},
\code{\link{methods-princomp}},
\code{\link{methods-svd}}
}
\concept{methods for singular value decomposition-based techniques}
