% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_pkg_usage.R
\name{check_pkg_usage}
\alias{check_pkg_usage}
\title{Check which packages are actually used in a project}
\usage{
check_pkg_usage(
  path = getwd(),
  pkgs = getOption("origin.pkgs", .packages()),
  recursive = TRUE,
  exclude_files = NULL,
  path_to_local_functions = NULL,
  check_local_conflicts = TRUE,
  use_markers = TRUE
)
}
\arguments{
\item{path}{a character vector of full path names; the default corresponds 
to the working directory, \link[base]{getwd}()}

\item{pkgs}{a character vector with package names. Defaults to the result of
\link[base]{.packages} but only if the option `origin.pkgs` is not specified.}

\item{recursive}{logical. Should the listing recurse into directories?}

\item{exclude_files}{a character vector of file paths that should be 
excluded from being checked Helpful if all but a few files should be
considered by origin.}

\item{path_to_local_functions}{file path. Helpful if all project specific
functions are defined in a specific folder. This folder might not be a 
sub directory of the current project so the default to just find all 
function definitions would not be sufficient.}

\item{check_local_conflicts}{if TRUE, it is checked whether locally
defined functions inside of the project mask exported functions
packages listed in pkgs. It avoids mistakenly adding pkg:: to a
custom local function.}

\item{use_markers}{a boolean. If TRUE, the markers tab inn RStudio is used
to track changes and show issues. FALSE prints the same information in
the console.}
}
\value{
`data.frame` invisibly, It consists of 5 columns. 
- `pkg`: the package that exports this function
- `fun`: all functions in alphabetical order
- `n_calls`: how often the function has been used in the files
- `namespaced`: logical, whether the function has been called explicitly 
                via `pkg::fct` or implicitly by an attached package
- `conflict`: whether this function is exported by multiple checked packages
- `conflict_pkgs`: in case of a conflict, which packages does 
                  export the same function but are masked
 Note that functions for that it is unknown from which package they are 
 exported have an `NA` in the `pkg` column.
 Similarly, Packages that are checked but no functions from these are
 used are listed but have an `NA` in the `fun` column
}
\description{
Provide a folder and a vector of package names to check, 
which packages are actually in use and which functions are used but not 
exported by the provided packages.
}
\examples{
\dontrun{
check_pkg_usage()
}
}
