% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eol.R
\name{eol}
\alias{eol}
\alias{eol_invasive_data}
\title{Search for presence of taxonomic names in EOL invasive species databases.}
\usage{
eol(
  name,
  dataset = "all",
  searchby = grep,
  page = NULL,
  per_page = 500,
  key = NULL,
  messages = TRUE,
  count = FALSE,
  ...
)

eol_invasive_data(...)
}
\arguments{
\item{name}{A taxonomic name, or a vector of names.}

\item{dataset}{One of all, gisd100, gisd, isc, daisie, i3n, or mineps.
See the Details for what each dataset ID.}

\item{searchby}{One of 'grep' (exact match) or 'agrep' (fuzzy match)}

\item{page}{A maximum of 30 results are returned per page. This parameter
allows you to fetch more pages of results if there are more than 30 matches
(Default: 1)}

\item{per_page}{Results to get per page. Default: 500}

\item{key}{Your EOL API key; loads from .Rprofile.}

\item{messages}{(logical) If \code{TRUE} the actual taxon queried is printed
on the console.}

\item{count}{(logical) If TRUE, give back a count of number of taxa listed
as invasive, if \code{FALSE} (default), the normal output is given.}

\item{...}{curl options passed on to \code{\link[crul]{HttpClient}}}
}
\value{
A list of data.frame's/strings with results, with each element
named by the input elements to the name parameter.
}
\description{
See Details for important information.
}
\details{
\code{eol_invasive_data()} gives you the entire data.frame from
the "dataset=all", while \code{eol()} let's you search on a vector of names
against any of the datasets

IMPORTANT: note that setting \code{dataset="all"} will give you surprising results.
EOL does not include informaiton on which of the invasive datasets (i.e., gisd100,
gisd, isc, daisie, i3n, or mineps) the taxon is found in, and sometimes e.g., if
taxon X is in GISD, you might not find it in "all", weird. I don't know
why that's happening, but it shouldn't happen.

IMPORTANT: When you get a returned NaN for a taxon, that means it's not on
the invasive list in question. If the taxon is found, a taxon identifier
is returned.

Beware that some datasets are quite large, and may take 30 sec to a minute to
pull down all data before we can search for your species. Note there is no
parameter in this API method for searching by taxon name.

\code{eol()} is vectorized, so you can pass a single name or a vector
of names.

It's possible to return JSON or XML with the EOL API. However, this function
only returns JSON.

Options for the dataset parameter are
\itemize{
\item all - All datasets
\item gisd100 - 100 of the World's Worst Invasive Alien Species
(Global Invasive Species Database) https://eol.org/resources/477
\item gisd - Global Invasive Species Database 2013
http://eol.org/collections/54983
\item isc - Centre for Agriculture and Biosciences International Invasive
Species Compendium (ISC) http://eol.org/collections/55180
\item daisie - Delivering Alien Invasive Species Inventories for Europe
(DAISIE) Species List http://eol.org/collections/55179
\item i3n - IABIN Invasives Information Network (I3N) Species
http://eol.org/collections/55176
\item mineps - Marine Invaders of the NE Pacific
Species http://eol.org/collections/55331
}

Datasets are not updated that often. Here's last updated dates for some of
the datasets as of 2014-08-25
\itemize{
\item gisd100 updated 6 mos ago
\item gisd  updated 1 yr ago
\item isc updated 1 yr ago
\item daisie updated 1 yr ago
\item i3n updated 1 yr ago
\item mineps updated 1 yr ago
}
}
\examples{
\dontrun{
eol(name='Brassica oleracea', dataset='gisd')
eol(name=c('Lymantria dispar','Cygnus olor','Hydrilla verticillata',
  'Pinus concolor'), dataset='gisd')
eol(name='Sargassum', dataset='gisd')
eol(name='Ciona intestinalis', dataset='mineps')
eol(name=c('Lymantria dispar','Cygnus olor','Hydrilla verticillata',
  'Pinus concolor'), dataset='i3n')
eol(name=c('Branta canadensis','Gallus gallus','Myiopsitta monachus'),
   dataset='daisie')
eol(name=c('Branta canadensis','Gallus gallus','Myiopsitta monachus'),
  dataset='isc')

# Count
eol(name=c('Lymantria dispar','Cygnus olor','Hydrilla verticillata',
  'Pinus concolor'), dataset='gisd', count = TRUE)

# curl options
eol(name='Sargassum', dataset='gisd', verbose = TRUE)
}
}
