% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/afniS4.R
\name{readAFNI}
\alias{readAFNI}
\title{readAFNI}
\usage{
readAFNI(fname, vol = NULL, verbose = FALSE, warn = -1, call = NULL)
}
\arguments{
\item{fname}{is the file name of the AFNI file.}

\item{vol}{vector of brick numbers to be read from file.}

\item{verbose}{is a logical variable (default = \code{FALSE}) that allows
text-based feedback during execution of the function.}

\item{warn}{is a number to regularegulatete the display of warnings (default
= -1).  See \code{options} for more details.}

\item{call}{keeps track of the current function call for use in the AFNI
extension.}
}
\value{
object of class \code{\linkS4class{afni}}
}
\description{
These functions read in the header information and
multidimensional array from a binary file in AFNI format into a
\code{\linkS4class{afni}}-class object.
}
\details{
The \code{readAFNI} function utilizes internal methods \code{readBin} and
\code{readLines} to efficiently extract information from the header and
binary file(s).  Compression is allowed on the BRIK file using gzip.

Current acceptable data types include \describe{ \item{list("INT16")}{DT
SIGNED SHORT (16 bits per voxel)} \item{list("FLOAT32")}{DT FLOAT (32 bits
per voxel)} \item{list("COMPLEX128")}{DT COMPLEX (128 bits per voxel)} }
}
\examples{
\dontrun{
## Taken from the AFNI Matlab Library
## http://afni.nimh.nih.gov/pub/dist/data/afni_matlab_data.tgz
afni.path <- system.file("afni", package="oro.nifti")
orig <- readAFNI(file.path(afni.path, "ARzs_CW_avvr.DEL+orig"))
image(orig, zlim=c(0.5,256), oma=rep(2,4))
orthographic(orig, zlim=c(0.5,256), oma=rep(2,4))
## Taken from the AFNI installation
TT <- readAFNI(file.path(afni.path, "TT_N27_EZ_LR+tlrc"))
image(TT, zlim=c(0.5,256), oma=rep(2,4))
orthographic(TT, zlim=c(0.5,256), oma=rep(2,4))
}
}
\author{
Karsten Tabelow \email{karsten.tabelow@wias-berlin.de}
}
\references{
AFNI\cr
\url{http://afni.nimh.nih.gov/pub/dist/src/README.attributes}
}
\seealso{
\code{\link{readANALYZE}}, \code{\link{readNIfTI}}
}
\keyword{file}
\keyword{methods}

