% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descrip.R
\docType{methods}
\name{descrip-methods}
\alias{descrip-methods}
\alias{descrip-methods,}
\alias{descrip}
\alias{descrip,nifti-method}
\alias{descrip,anlz-method}
\alias{descrip<-}
\alias{descrip<-,nifti-method}
\alias{descrip<-,anlz-method}
\title{Extract Image Attribute \code{descrip}}
\usage{
descrip(object)

\S4method{descrip}{nifti}(object)

\S4method{descrip}{anlz}(object)

descrip(object) <- value

\S4method{descrip}{nifti}(object) <- value

\S4method{descrip}{anlz}(object) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{descrip} field.}
}
\description{
Methods that act on the \code{descrip} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
\dontrun{
url <- "http://nifti.nimh.nih.gov/nifti-1/data/avg152T1_LR_nifti.nii.gz"
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                     "mniLR.nii.gz")
download.file(url, urlfile, quiet=TRUE)
}
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                     "mniLR.nii.gz")
mniLR <- readNIfTI(urlfile)
descrip(mniLR)
\dontrun{
descrip(mniLR) <- paste(descrip(mniLR), version$version.string, sep="; ")
descrip(mniLR)
}
}
\references{
ANALYZE 7.5\cr
\url{https://rportal.mayo.edu/bir/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
