% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{surv_dm_solver}
\alias{surv_dm_solver}
\title{surv_dm_solver \code{C++} function}
\usage{
surv_dm_solver(
  B,
  X,
  Phit,
  Fail_Ind,
  bw,
  rho,
  eta,
  gamma,
  tau,
  epsilon,
  btol,
  ftol,
  gtol,
  maxitr,
  verbose,
  ncore
)
}
\arguments{
\item{B}{A matrix of the parameters \code{B}, the columns are subject to the orthogonality constraint}

\item{X}{The covariate matrix (This matrix is ordered by the order of Y for faster computation)}

\item{Phit}{Phit as defined in Sun et al. (2017)}

\item{Fail_Ind}{The locations of the failure subjects}

\item{bw}{Kernel bandwidth for X}

\item{rho}{(don't change) Parameter for control the linear approximation in line search}

\item{eta}{(don't change) Factor for decreasing the step size in the backtracking line search}

\item{gamma}{(don't change) Parameter for updating C by Zhang and Hager (2004)}

\item{tau}{(don't change) Step size for updating}

\item{epsilon}{(don't change) Parameter for approximating numerical gradient}

\item{btol}{(don't change) The \code{$B$} parameter tolerance level}

\item{ftol}{(don't change) Estimation equation 2-norm tolerance level}

\item{gtol}{(don't change) Gradient tolerance level}

\item{maxitr}{Maximum number of iterations}

\item{verbose}{Should information be displayed}

\item{ncore}{The number of cores for parallel computing}

\item{bw_optim}{whether to optimize the bandwidth}
}
\value{
The optimizer \code{B} for the estimating equation.
}
\description{
The main optimization function for survival dimensional reduction, the IR-Semi method. This is an internal function and should not be called directly.
}
\examples{
# This function should be called internally. When having all objects pre-computed, one can call
# surv_solver(B, X, Phit, Fail.Ind,
#             rho, eta, gamma, tau, epsilon, btol, ftol, gtol, maxitr, verbose)
# to solve for the parameters B.

}
\references{
Sun, Q., Zhu, R., Wang, T., & Zeng, D. (2019). Counting process-based dimension reduction methods for censored outcomes.
Biometrika, 106(1), 181-196.
DOI: \doi{10.1093/biomet/asy064}
}
\keyword{internal}
