% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_map_notes.R
\name{osm_create_comment_note}
\alias{osm_create_comment_note}
\title{Create a new comment in a note}
\usage{
osm_create_comment_note(note_id, text)
}
\arguments{
\item{note_id}{Note id represented by a numeric or a character value.}

\item{text}{The comment as arbitrary text.}
}
\value{
Returns a data frame with the map note and the new comment (same format as \code{\link[=osm_get_notes]{osm_get_notes()}} with
\code{format = "R"}).
}
\description{
Add a new comment to an existing note. Requires authentication.
}
\examples{
\dontrun{
set_osmapi_connection("testing") # use the testing server
note <- osm_get_notes(53726)
updated_note <- osm_create_comment_note(note$id, text = "A new comment to the note")
updated_note
}
}
\seealso{
Other edit notes' functions: 
\code{\link{osm_close_note}()},
\code{\link{osm_create_note}()},
\code{\link{osm_delete_note}()}
}
\concept{edit notes' functions}
