% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opq.R
\name{add_osm_feature}
\alias{add_osm_feature}
\title{Add a feature to an Overpass query}
\usage{
add_osm_feature(
  opq,
  key,
  value,
  key_exact = TRUE,
  value_exact = TRUE,
  match_case = TRUE,
  bbox = NULL
)
}
\arguments{
\item{opq}{An \code{overpass_query} object}

\item{key}{feature key; can be negated with an initial exclamation mark,
\code{key = "!this"}, and can also be a vector if \code{value} is missing.}

\item{value}{value for feature key; can be negated with an initial
exclamation mark, \code{value = "!this"}, and can also be a vector,
\code{value = c ("this", "that")}.}

\item{key_exact}{If FALSE, \code{key} is not interpreted exactly; see
\url{https://wiki.openstreetmap.org/wiki/Overpass_API}}

\item{value_exact}{If FALSE, \code{value} is not interpreted exactly}

\item{match_case}{If FALSE, matching for both \code{key} and \code{value} is
not sensitive to case}

\item{bbox}{optional bounding box for the feature query; must be set if no
opq query bbox has been set}
}
\value{
\link{opq} object
}
\description{
Add a feature to an Overpass query
}
\note{
\code{key_exact} should generally be \code{TRUE}, because OSM uses a
reasonably well defined set of possible keys, as returned by
\link{available_features}. Setting \code{key_exact = FALSE} allows matching
of regular expressions on OSM keys, as described in Section 6.1.5 of
\url{https://wiki.openstreetmap.org/wiki/Overpass_API/Overpass_QL}. The actual
query submitted to the overpass API can be obtained from
\link{opq_string}.
}
\section{\code{add_osm_feature} vs \code{add_osm_features}}{

Features defined within an \link{add_osm_features} call are combined with a
logical OR.

Chained calls to either \link{add_osm_feature} or \code{add_osm_features()} combines
features from these calls in a logical AND; this is analagous to chaining
\code{dplyr::filter()} on a data frame.

\code{add_osm_features()} with only one feature is logically equivalent to
\code{add_osm_feature()}.
}

\examples{
\dontrun{
q <- opq ("portsmouth usa") \%>\%
    add_osm_feature (
        key = "amenity",
        value = "restaurant"
    ) \%>\%
    add_osm_feature (key = "amenity", value = "pub")
osmdata_sf (q) # all objects that are restaurants AND pubs (there are none!)
q1 <- opq ("portsmouth usa") \%>\%
    add_osm_feature (
        key = "amenity",
        value = "restaurant"
    )
q2 <- opq ("portsmouth usa") \%>\%
    add_osm_feature (key = "amenity", value = "pub")
c (osmdata_sf (q1), osmdata_sf (q2)) # all restaurants OR pubs
# Use of negation to extract all non-primary highways
q <- opq ("portsmouth uk") \%>\%
    add_osm_feature (key = "highway", value = "!primary")

# key negation without warnings
q3 <- opq ("Vinçà", osm_type="node") \%>\%
    add_osm_feature (key = c("name", "!name:ca"))
q4 <- opq ("el Carxe", osm_type="node") \%>\%
    add_osm_feature (key = "natural", value = "peak") \%>\%
    add_osm_feature (key = "!ele")
}
}
\references{
\url{https://wiki.openstreetmap.org/wiki/Map_Features}
}
\seealso{
\link{add_osm_features}

Other queries: 
\code{\link{add_osm_features}()},
\code{\link{bbox_to_string}()},
\code{\link{getbb}()},
\code{\link{opq_around}()},
\code{\link{opq_enclosing}()},
\code{\link{opq_osm_id}()},
\code{\link{opq_string}()},
\code{\link{opq}()},
\code{\link{overpass_status}()}
}
\concept{queries}
