% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-osmdata-sp.R
\name{osmdata_sp}
\alias{osmdata_sp}
\title{Return an OSM Overpass query as an \link{osmdata} object in \pkg{sp}
format.}
\usage{
osmdata_sp(q, doc, quiet = TRUE)
}
\arguments{
\item{q}{An object of class \code{overpass_query} constructed with
\link{opq} and \link{add_osm_feature}. May be be omitted,
in which case the \link{osmdata} object will not include the
query.}

\item{doc}{If missing, \code{doc} is obtained by issuing the overpass query,
\code{q}, otherwise either the name of a file from which to read data,
or an object of class \pkg{xml2} returned from
\link{osmdata_xml}.}

\item{quiet}{suppress status messages.}
}
\value{
An object of class \code{osmdata} with the OSM components (points, lines,
and polygons) represented in \pkg{sp} format.
}
\description{
Return an OSM Overpass query as an \link{osmdata} object in \pkg{sp}
format.
}
\examples{
\dontrun{
hampi_sp <- opq ("hampi india") \%>\%
    add_osm_feature (key = "historic", value = "ruins") \%>\%
    osmdata_sp ()
}
}
\seealso{
Other extract: 
\code{\link{osmdata_data_frame}()},
\code{\link{osmdata_sc}()},
\code{\link{osmdata_sf}()},
\code{\link{osmdata_xml}()}
}
\concept{extract}
