/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.stage;

import fr.ird.osmose.IMarineOrganism;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.stage.AbstractStage;
import fr.ird.osmose.stage.AgeStage;
import fr.ird.osmose.stage.IStage;
import fr.ird.osmose.stage.SizeStage;

public class DietOutputStage
implements IStage {
    private AbstractStage stage;

    @Override
    public void init() {
        String metrics = null;
        try {
            metrics = Osmose.getInstance().getConfiguration().getString("output.diet.stage.structure");
            if (!metrics.equalsIgnoreCase("size") && !metrics.equalsIgnoreCase("age")) {
                metrics = null;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (null != metrics) {
            if (metrics.equalsIgnoreCase("size")) {
                this.stage = new SizeStage("output.diet.stage.threshold.sp");
            } else if (metrics.equalsIgnoreCase("age")) {
                this.stage = new AgeStage("output.diet.stage.threshold.sp");
            }
        } else {
            Osmose.getInstance().warning("Could not find parameter 'output.diet.stage.structure' (or unsupported value, must be either 'age' or 'size'). Osmose assumes it is age-based threshold.");
            this.stage = new AgeStage("output.diet.stage.threshold.sp");
        }
        this.stage.init();
    }

    @Override
    public int getNStage(int iSpecies) {
        return this.stage.getNStage(iSpecies);
    }

    @Override
    public float[] getThresholds(int iSpecies) {
        return this.stage.getThresholds(iSpecies);
    }

    @Override
    public int getStage(IMarineOrganism school) {
        return this.stage.getStage(school);
    }
}

