/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose;

import fr.ird.osmose.Configuration;
import fr.ird.osmose.Simulation;
import fr.ird.osmose.grid.IGrid;
import fr.ird.osmose.util.logging.OLogger;
import fr.ird.osmose.util.version.VersionManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class Osmose
extends OLogger {
    private static final Osmose osmose = new Osmose();
    private final String fileSeparator = System.getProperty("file.separator");
    private Simulation[] simulation;
    private Configuration configuration;
    private String outputPathName;
    private List<String> configurationFiles;

    public void readArgs(String ... args) {
        this.configurationFiles = new ArrayList<String>();
        if (args.length > 0) {
            this.configurationFiles.add(new File(args[0]).getAbsolutePath());
        } else {
            this.configurationFiles.addAll(this.readFilepath());
        }
        if (args.length > 1) {
            this.outputPathName = args[1];
            if (!this.outputPathName.endsWith(this.fileSeparator)) {
                this.outputPathName = this.outputPathName + this.fileSeparator;
            }
        }
    }

    public void init() {
        this.configuration = new Configuration(this.configurationFiles.get(0), this.outputPathName);
        this.configuration.init();
        this.simulation = new Simulation[this.configuration.getNSimulation()];
        for (int i = 0; i < this.configuration.getNSimulation(); ++i) {
            this.simulation[i] = new Simulation(i);
        }
    }

    public void runAll() {
        for (String configurationFile : this.configurationFiles) {
            this.info("Running configuration {0}", configurationFile);
            osmose.run(configurationFile);
            this.info("*********************************");
        }
    }

    public void run(String configurationFile) {
        this.configuration = new Configuration(configurationFile, this.outputPathName);
        this.configuration.init();
        this.simulation = new Simulation[this.configuration.getNSimulation()];
        for (int i = 0; i < this.configuration.getNSimulation(); ++i) {
            this.simulation[i] = new Simulation(i);
        }
        long begin = System.currentTimeMillis();
        this.info("Simulation started...");
        int nProcs = Math.min(this.configuration.getNCpu(), Runtime.getRuntime().availableProcessors());
        int nBatch = (int)Math.ceil((float)this.configuration.getNSimulation() / (float)nProcs);
        int rank = 0;
        for (int iBatch = 0; iBatch < nBatch; ++iBatch) {
            int iworker;
            int nworker = Math.min(nProcs, this.configuration.getNSimulation() - rank);
            CountDownLatch doneSignal = new CountDownLatch(nworker);
            Worker[] workers = new Worker[nworker];
            for (iworker = 0; iworker < nworker; ++iworker) {
                workers[iworker] = new Worker(rank, doneSignal);
                ++rank;
            }
            for (iworker = 0; iworker < nworker; ++iworker) {
                new Thread(workers[iworker]).start();
            }
            try {
                doneSignal.await();
            }
            catch (InterruptedException ex) {
                this.error("Simulation " + rank + " terminated unexpectedly.", ex);
            }
            for (iworker = 0; iworker < nworker; ++iworker) {
                this.simulation[iBatch * nProcs + iworker] = null;
            }
        }
        int time = (int)((System.currentTimeMillis() - begin) / 1000L);
        this.info("Simulation completed (time ellapsed:  {0} seconds)", time);
    }

    public List<String> readFilepath() {
        String[] names = new String[]{"filePath.txt", "FilePath.txt", "Filepath.txt", "filepath.txt"};
        String filename = null;
        for (String name : names) {
            if (!new File(name).exists()) continue;
            filename = name;
            break;
        }
        FileInputStream filepath = null;
        try {
            filepath = new FileInputStream(new File(filename));
        }
        catch (FileNotFoundException ex) {
            String wd = new File("").getAbsolutePath();
            this.error("Did not find either {filePath.txt|FilePath.txt|Filepath.txt|filepath.txt} in current directory " + wd, ex);
        }
        this.info("Reading filePath.txt");
        BufferedReader bfIn = new BufferedReader(new InputStreamReader(filepath));
        ArrayList<String> cfgFiles = new ArrayList<String>();
        try {
            String line;
            while ((line = bfIn.readLine()) != null) {
                if (!(!(line = line.trim()).startsWith("#") & !line.startsWith("//") & line.length() > 1)) continue;
                String file = line;
                if (line.startsWith(";") & line.endsWith(";")) {
                    file = line.substring(1, line.length() - 1);
                }
                cfgFiles.add(new File(file).getAbsolutePath());
            }
            bfIn.close();
        }
        catch (IOException ex) {
            this.error("Error reading filepath file " + filename, ex);
        }
        return cfgFiles;
    }

    public static void main(String ... args) {
        osmose.info("*********************************");
        osmose.info("Osmose model - Copyright 2013 IRD");
        osmose.info("*********************************");
        osmose.info("Osmose version {0}", VersionManager.getInstance().OSMOSE_VERSION.toString());
        osmose.readArgs(args);
        osmose.runAll();
        osmose.info("*   Osmose model - Exit");
        osmose.info("*********************************");
    }

    public static Osmose getInstance() {
        return osmose;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Simulation getSimulation(int rank) {
        return this.simulation[rank];
    }

    public IGrid getGrid() {
        return this.configuration.getGrid();
    }

    private class Worker
    implements Runnable {
        private final int rank;
        private final CountDownLatch doneSignal;

        public Worker(int rank, CountDownLatch doneSignal) {
            this.rank = rank;
            this.doneSignal = doneSignal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long begin = System.currentTimeMillis();
            try {
                Osmose.this.simulation[this.rank].info("Started...");
                Osmose.this.simulation[this.rank].init();
                Osmose.this.simulation[this.rank].run();
                int time = (int)((System.currentTimeMillis() - begin) / 1000L);
                Osmose.this.simulation[this.rank].info("Completed (time ellapsed: {0} seconds)", time);
                Osmose.this.simulation[this.rank].destroy();
            }
            finally {
                this.doneSignal.countDown();
            }
        }
    }
}

