/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose;

import fr.ird.osmose.Cell;
import fr.ird.osmose.Configuration;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.grid.IGrid;
import fr.ird.osmose.util.filter.AliveSchoolFilter;
import fr.ird.osmose.util.filter.DeadSchoolFilter;
import fr.ird.osmose.util.filter.FilteredSet;
import fr.ird.osmose.util.filter.FilteredSets;
import fr.ird.osmose.util.filter.IFilter;
import fr.ird.osmose.util.filter.OutSchoolFilter;
import fr.ird.osmose.util.filter.PresentSchoolFilter;
import fr.ird.osmose.util.filter.SpeciesFilter;
import java.util.ArrayList;
import java.util.List;

public class SchoolSet
extends FilteredSet<School> {
    private List<School>[][] schoolMap;
    private final List<School>[] arrSpecies = new ArrayList[this.getConfiguration().getNSpecies()];
    private final boolean[] hasSpeciesChanged = new boolean[this.getConfiguration().getNSpecies()];

    SchoolSet() {
        for (int i = 0; i < this.getConfiguration().getNSpecies(); ++i) {
            this.hasSpeciesChanged[i] = true;
        }
    }

    public void removeDeadSchools() {
        FilteredSet<School> schoolsToRemove = FilteredSets.subset(this, new DeadSchoolFilter());
        this.removeAll(schoolsToRemove);
        for (int i = 0; i < this.getConfiguration().getNSpecies(); ++i) {
            this.hasSpeciesChanged[i] = true;
        }
    }

    public List<School> getSchools(Species species, boolean update) {
        if (update || this.hasSpeciesChanged[species.getIndex()]) {
            this.arrSpecies[species.getIndex()] = FilteredSets.subset(this, new IFilter[]{new SpeciesFilter(species.getIndex()), new AliveSchoolFilter()});
            this.hasSpeciesChanged[species.getIndex()] = false;
        }
        return this.arrSpecies[species.getIndex()];
    }

    public List<School> getSchools(Species species) {
        return this.getSchools(species, true);
    }

    public List<School> getSchools(Cell cell) {
        return this.schoolMap[cell.get_jgrid()][cell.get_igrid()];
    }

    public List<School> getPresentSchools() {
        return FilteredSets.subset(this, new PresentSchoolFilter());
    }

    public List<School> getOutSchools() {
        return FilteredSets.subset(this, new OutSchoolFilter());
    }

    public List<School> getAliveSchools() {
        return FilteredSets.subset(this, new AliveSchoolFilter());
    }

    public void updateSchoolMap() {
        IGrid grid = Osmose.getInstance().getGrid();
        if (null == this.schoolMap) {
            this.schoolMap = new ArrayList[grid.get_ny()][grid.get_nx()];
        }
        for (int j = 0; j < grid.get_ny(); ++j) {
            for (int i = 0; i < grid.get_nx(); ++i) {
                if (grid.getCell(i, j).isLand()) continue;
                if (null == this.schoolMap[j][i]) {
                    this.schoolMap[j][i] = new ArrayList<School>();
                    continue;
                }
                this.schoolMap[j][i].clear();
            }
        }
        for (School school : this) {
            if (school.isUnlocated()) continue;
            this.schoolMap[school.getCell().get_jgrid()][school.getCell().get_igrid()].add(school);
        }
    }

    private Configuration getConfiguration() {
        return Osmose.getInstance().getConfiguration();
    }
}

