/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality;

import fr.ird.osmose.Cell;
import fr.ird.osmose.School;
import fr.ird.osmose.process.AbstractProcess;
import fr.ird.osmose.process.mortality.AdditionalMortality;
import fr.ird.osmose.process.mortality.FishingMortality;
import fr.ird.osmose.process.mortality.MortalityCause;
import fr.ird.osmose.process.mortality.PredationMortality;
import fr.ird.osmose.process.mortality.StarvationMortality;
import java.util.Arrays;
import java.util.List;

public class IterativeMortalityProcess
extends AbstractProcess {
    private AdditionalMortality additionalMortality;
    private FishingMortality fishingMortality;
    private StarvationMortality starvationMortality;
    private PredationMortality predationMortality;
    private final double epsilon = 0.01;
    private int iterMin;
    private int iterMax;
    private int iterMean;
    private int nIterProcess;

    public IterativeMortalityProcess(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        this.additionalMortality = new AdditionalMortality(this.getRank());
        this.additionalMortality.init();
        this.fishingMortality = new FishingMortality(this.getRank());
        this.fishingMortality.init();
        this.starvationMortality = new StarvationMortality(this.getRank());
        this.starvationMortality.init();
        this.predationMortality = new PredationMortality(this.getRank());
        this.predationMortality.init();
        this.iterMin = Integer.MAX_VALUE;
        this.iterMax = 0;
        this.iterMean = 0;
        this.nIterProcess = 0;
    }

    @Override
    public void run() {
        this.fishingMortality.setMPA();
        this.fishingMortality.assessFishableBiomass();
        int nspec = this.getConfiguration().getNSpecies();
        boolean keepRecord = this.getSimulation().isPreyRecord();
        for (Cell cell : this.getGrid().getCells()) {
            List<School> schools = this.getSchoolSet().getSchools(cell);
            if (cell.isLand() || schools.isEmpty()) continue;
            int ns = schools.size();
            int npl = this.getConfiguration().getNPlankton();
            double[][] nDeadMatrix = this.computeMortality_iterative(cell);
            for (int is = 0; is < ns; ++is) {
                School school = schools.get(is);
                school.resetNdead(MortalityCause.PREDATION);
                for (int ipd = 0; ipd < ns; ++ipd) {
                    school.incrementNdead(MortalityCause.PREDATION, nDeadMatrix[is][ipd]);
                }
                school.setNdead(MortalityCause.STARVATION, nDeadMatrix[is][ns]);
                school.setNdead(MortalityCause.ADDITIONAL, nDeadMatrix[is][ns + 1]);
                school.setNdead(MortalityCause.FISHING, nDeadMatrix[is][ns + 2]);
                for (int ipr = 0; ipr < ns + npl; ++ipr) {
                    if (!(nDeadMatrix[ipr][is] > 0.0)) continue;
                    if (ipr < ns) {
                        School prey = schools.get(ipr);
                        school.preyedUpon(prey.getSpeciesIndex(), prey.getTrophicLevel(), prey.getAge(), prey.getLength(), prey.adb2biom(nDeadMatrix[ipr][is]), keepRecord);
                        continue;
                    }
                    int index = ipr - ns + nspec;
                    school.preyedUpon(index, this.getSimulation().getPlankton(ipr - ns).getTrophicLevel(), -1.0f, -1.0f, nDeadMatrix[ipr][is], keepRecord);
                }
                double maxPreyedBiomass = school.getBiomass() * this.predationMortality.getMaxPredationRate(school);
                school.setPredSuccessRate(this.predationMortality.computePredSuccessRate(maxPreyedBiomass, school.getPreyedBiomass()));
            }
        }
        this.performanceIterative();
    }

    public double[][] computeMortality_iterative(Cell cell) {
        int iteration;
        int iPrey;
        int ITER_MAX = 50;
        double ERR_MAX = 1.0E-5;
        List<School> schools = this.getSchoolSet().getSchools(cell);
        int nSchool = schools.size();
        int nPlankton = this.getConfiguration().getNPlankton();
        int nMortality = nSchool + 3;
        double[][] nDeadMatrix = new double[nSchool + nPlankton][nMortality];
        double[][] mortalityRateMatrix = new double[nSchool + nPlankton][nMortality];
        double[] totalMortalityRate = new double[nSchool + nPlankton];
        double[] correctionFactor = new double[nSchool];
        double[] planktonBiomass = new double[nPlankton];
        for (int iPlk = 0; iPlk < nPlankton; ++iPlk) {
            planktonBiomass[iPlk] = this.getSimulation().getPlankton(iPlk).getBiomass(cell);
        }
        double[][] predationMatrix = this.predationMortality.computePredationMatrix(cell, false, 1);
        for (iPrey = 0; iPrey < nSchool + nPlankton; ++iPrey) {
            for (int iPredator = 0; iPredator < nSchool; ++iPredator) {
                double predationMortalityRate;
                if (iPrey < nSchool) {
                    School school = schools.get(iPrey);
                    nDeadMatrix[iPrey][iPredator] = school.biom2abd(predationMatrix[iPredator][iPrey]);
                    predationMortalityRate = Math.log(school.getAbundance() / (school.getAbundance() - nDeadMatrix[iPrey][iPredator]));
                } else {
                    nDeadMatrix[iPrey][iPredator] = predationMatrix[iPredator][iPrey];
                    double planktonAbundance = planktonBiomass[iPrey - nSchool];
                    predationMortalityRate = planktonAbundance > 0.0 ? Math.log(planktonAbundance / (planktonAbundance - predationMatrix[iPredator][iPrey])) : 0.0;
                }
                mortalityRateMatrix[iPrey][iPredator] = predationMortalityRate;
            }
        }
        block7: for (int is = 0; is < nSchool; ++is) {
            School school = schools.get(is);
            double preyedBiomass = 0.0;
            for (int iPrey2 = 0; iPrey2 < nSchool + nPlankton; ++iPrey2) {
                preyedBiomass += predationMatrix[is][iPrey2];
            }
            double biomassToPredate = school.getBiomass() * this.predationMortality.getMaxPredationRate(school);
            school.setPredSuccessRate(this.predationMortality.computePredSuccessRate(biomassToPredate, preyedBiomass));
            mortalityRateMatrix[is][nSchool] = this.starvationMortality.getRate(school);
            mortalityRateMatrix[is][nSchool + 1] = this.additionalMortality.getRate(school);
            switch (this.fishingMortality.getType()) {
                case RATE: {
                    mortalityRateMatrix[is][nSchool + 2] = this.fishingMortality.getRate(school);
                    continue block7;
                }
                case CATCHES: {
                    double catches = this.fishingMortality.getCatches(school);
                    mortalityRateMatrix[is][nSchool + 2] = school.getBiomass() - catches < 0.01 ? Math.log(school.getAbundance() / 0.01) : Math.log(school.getAbundance() / (school.getAbundance() - school.biom2abd(catches)));
                }
            }
        }
        for (iPrey = 0; iPrey < nSchool + nPlankton; ++iPrey) {
            for (int iMortality = 0; iMortality < nMortality; ++iMortality) {
                int n = iPrey;
                totalMortalityRate[n] = totalMortalityRate[n] + mortalityRateMatrix[iPrey][iMortality];
            }
        }
        double error = Double.MAX_VALUE;
        for (iteration = 0; iteration < ITER_MAX && error > ERR_MAX; ++iteration) {
            int iPrey3;
            for (iPrey3 = 0; iPrey3 < nSchool + nPlankton; ++iPrey3) {
                double abundance = iPrey3 < nSchool ? schools.get(iPrey3).getAbundance() : planktonBiomass[iPrey3 - nSchool];
                for (int iMortality = 0; iMortality < nMortality; ++iMortality) {
                    nDeadMatrix[iPrey3][iMortality] = totalMortalityRate[iPrey3] > 0.0 ? mortalityRateMatrix[iPrey3][iMortality] / totalMortalityRate[iPrey3] * (1.0 - Math.exp(-totalMortalityRate[iPrey3])) * abundance : 0.0;
                }
            }
            for (int iPredator = 0; iPredator < nSchool; ++iPredator) {
                School predator = schools.get(iPredator);
                double preyedBiomass = 0.0;
                for (int iPrey4 = 0; iPrey4 < nSchool + nPlankton; ++iPrey4) {
                    if (iPrey4 < nSchool) {
                        preyedBiomass += schools.get(iPrey4).adb2biom(nDeadMatrix[iPrey4][iPredator]);
                        continue;
                    }
                    preyedBiomass += nDeadMatrix[iPrey4][iPredator];
                }
                double biomassToPredate = predator.getBiomass() * this.predationMortality.getMaxPredationRate(predator);
                predator.setPredSuccessRate(this.predationMortality.computePredSuccessRate(biomassToPredate, preyedBiomass));
                correctionFactor[iPredator] = preyedBiomass > 0.0 ? Math.min(biomassToPredate / preyedBiomass, 1.0) : 1.0;
            }
            for (iPrey3 = 0; iPrey3 < nSchool + nPlankton; ++iPrey3) {
                for (int iPredator = 0; iPredator < nSchool; ++iPredator) {
                    double[] dArray = mortalityRateMatrix[iPrey3];
                    int n = iPredator;
                    dArray[n] = dArray[n] * correctionFactor[iPredator];
                }
            }
            for (iPrey3 = 0; iPrey3 < nSchool; ++iPrey3) {
                School school = schools.get(iPrey3);
                mortalityRateMatrix[iPrey3][nSchool] = this.starvationMortality.getRate(school);
            }
            double[] oldTotalMortalityRate = Arrays.copyOf(totalMortalityRate, totalMortalityRate.length);
            error = 0.0;
            for (int iPrey5 = 0; iPrey5 < nSchool + nPlankton; ++iPrey5) {
                totalMortalityRate[iPrey5] = 0.0;
                for (int iMortality = 0; iMortality < nMortality; ++iMortality) {
                    int n = iPrey5;
                    totalMortalityRate[n] = totalMortalityRate[n] + mortalityRateMatrix[iPrey5][iMortality];
                }
                error = Math.max(error, Math.abs(totalMortalityRate[iPrey5] - oldTotalMortalityRate[iPrey5]));
            }
        }
        if (iteration < this.iterMin) {
            this.iterMin = iteration;
        }
        if (iteration > this.iterMax) {
            this.iterMax = iteration;
        }
        this.iterMean += iteration;
        ++this.nIterProcess;
        return nDeadMatrix;
    }

    private void performanceIterative() {
        float mean = (float)this.iterMean / (float)this.nIterProcess;
        this.debug("Iterative mortality algorithm. Iteration min " + this.iterMin + " iteration max " + this.iterMax + " iteration mean " + mean);
    }
}

