/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum Separator {
    EQUALS('='),
    SEMICOLON(';'),
    COMA(','),
    COLON(':'),
    TAB('\t');

    private final char separator;

    private Separator(char separator) {
        this.separator = separator;
    }

    public String toString() {
        return String.valueOf(this.separator);
    }

    public char getSeparator() {
        return this.separator;
    }

    public static String asList() {
        StringBuilder list = new StringBuilder();
        for (Separator sep : Separator.values()) {
            list.append(sep.name()).append(" ");
        }
        return list.toString();
    }

    public static Separator guess(String string, Separator fallback) {
        for (Separator guess : Separator.values()) {
            if (!string.contains(guess.toString()) || string.split(guess.toString()).length < 1) continue;
            return guess;
        }
        return fallback;
    }

    public static Separator guess(String filename) throws IOException {
        for (Separator guess : Separator.values()) {
            try {
                CSVReader reader = new CSVReader(new FileReader(filename), guess.separator);
                List<String[]> lines = reader.readAll();
                int n = Math.min(lines.size(), 50);
                boolean consistant = true;
                for (int i = 0; i < n - 1 && consistant; ++i) {
                    consistant = lines.get(i).length > 1 && lines.get(i).length == lines.get(i + 1).length;
                }
                if (!consistant) continue;
                Logger.getLogger(Separator.class.getName()).log(Level.FINE, "CSV separator for {0} is {1}", new Object[]{filename, guess.name()});
                return guess;
            }
            catch (IOException ex) {
                Logger.getLogger(Separator.class.getName()).log(Level.SEVERE, "Could not read CSV file " + filename, ex);
            }
        }
        throw new IOException("Failed to guess CSV separator");
    }
}

