/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class URLnaming {
    public static String escapeQueryNew(String urlString) throws URISyntaxException {
        urlString = urlString.trim();
        URI uri = new URI(urlString);
        return uri.toASCIIString();
    }

    public static String escapeQuery(String urlString) {
        String query;
        int posQ = (urlString = urlString.trim()).indexOf("?");
        if (posQ > 0 && posQ < urlString.length() - 2 && (query = urlString.substring(posQ)).indexOf("%") < 0) {
            String path = urlString.substring(0, posQ);
            try {
                urlString = path + URIUtil.encodeQuery((String)query);
            }
            catch (URIException e) {
                e.printStackTrace();
            }
        }
        return urlString;
    }

    public static String resolve(String baseUri, String relativeUri) {
        URI reletiveURI;
        if (baseUri == null || relativeUri == null) {
            return relativeUri;
        }
        if (relativeUri.startsWith("file:")) {
            return relativeUri;
        }
        if (baseUri.startsWith("file:")) {
            try {
                URI reletiveURI2 = URI.create(relativeUri);
                if (reletiveURI2.isAbsolute()) {
                    return relativeUri;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (relativeUri.length() > 0 && relativeUri.charAt(0) == '#') {
                return baseUri + relativeUri;
            }
            if (relativeUri.length() > 0 && relativeUri.charAt(0) == '/') {
                return relativeUri;
            }
            int pos = baseUri.lastIndexOf(47);
            if (pos > 0) {
                return baseUri.substring(0, pos + 1) + relativeUri;
            }
        }
        if ((reletiveURI = URI.create(relativeUri)).isAbsolute()) {
            return relativeUri;
        }
        URI baseURI = URI.create(baseUri);
        URI resolvedURI = baseURI.resolve(reletiveURI);
        return resolvedURI.toASCIIString();
    }

    public static String canonicalizeRead(String location) {
        try {
            URI refURI = URI.create(location);
            if (refURI.isAbsolute()) {
                return location;
            }
        }
        catch (Exception e) {
            return "file:" + location;
        }
        return location;
    }

    public static String canonicalizeWrite(String location) {
        try {
            URI refURI = URI.create(location);
            if (refURI.isAbsolute()) {
                return location;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "file:" + location;
    }

    public static String resolveFile(String baseDir, String filepath) {
        if (baseDir == null) {
            return filepath;
        }
        File file = new File(filepath);
        if (file.isAbsolute()) {
            return filepath;
        }
        return baseDir + filepath;
    }

    private static void test(String uriS) {
        System.out.println(uriS);
        URI uri = URI.create(uriS);
        System.out.println(" scheme=" + uri.getScheme());
        System.out.println(" getSchemeSpecificPart=" + uri.getSchemeSpecificPart());
        System.out.println(" getAuthority=" + uri.getAuthority());
        System.out.println(" getPath=" + uri.getPath());
        System.out.println(" getQuery=" + uri.getQuery());
        System.out.println();
    }

    public static void main1(String[] args) {
        URLnaming.testResolve("file:/test/me/", "blank in dir", "file:/test/me/blank in dir");
    }

    public static void main2(String[] args) {
        URLnaming.test("file:test/dir");
        URLnaming.test("file:/test/dir");
        URLnaming.test("file://test/dir");
        URLnaming.test("file:///test/dir");
        URLnaming.test("file:C:/Program Files (x86)/Apache Software Foundation/Tomcat 5.0/content/thredds/cache");
        URLnaming.test("file:C:\\Program Files (x86)\\Apache Software Foundation\\Tomcat 5.0\\content\\thredds\\cache");
        URLnaming.test("http://localhost:8080/thredds/catalog.html?hi=lo");
    }

    private static void testResolve(String base, String rel, String result) {
        System.out.println("\nbase= " + base);
        System.out.println("rel= " + rel);
        System.out.println("resolve= " + URLnaming.resolve(base, rel));
        if (result != null) assert (URLnaming.resolve(base, rel).equals(result));
    }

    public static void main3(String[] args) {
        URLnaming.testResolve("http://test/me/", "wanna", "http://test/me/wanna");
        URLnaming.testResolve("http://test/me/", "/wanna", "http://test/wanna");
        URLnaming.testResolve("file:/test/me/", "wanna", "file:/test/me/wanna");
        URLnaming.testResolve("file:/test/me/", "/wanna", "/wanna");
        URLnaming.testResolve("file://test/me/", "http:/wanna", "http:/wanna");
        URLnaming.testResolve("file://test/me/", "file:/wanna", "file:/wanna");
        URLnaming.testResolve("file://test/me/", "C:/wanna", "C:/wanna");
        URLnaming.testResolve("http://test/me/", "file:wanna", "file:wanna");
    }

    public static void main4(String[] args) {
        try {
            URL url = new URL("file:src/test/data/ncml/nc/");
            URI uri = new URI("file:src/test/data/ncml/nc/");
            File file = new File(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main5(String[] args) throws URISyntaxException {
        String uriString = "http://test.opendap.org:8080/dods/dts/test.53.dods?types[0:1:9]";
        URI uri = new URI(uriString);
    }

    public static void main(String[] args) throws URISyntaxException {
        String uriString = "http://test.opendap.org:8080/dods/dts/test.53.dods?types[0:1:9]";
        URI uri = new URI(uriString);
        System.out.printf("uri = %s%n", uri);
        System.out.printf("uri.toASCIIString = %s%n", uri.toASCIIString());
        System.out.printf("escapeQueryNew = %s%n", URLnaming.escapeQueryNew(uriString));
        System.out.printf("escapeQueryOld = %s%n", URLnaming.escapeQuery(uriString));
    }
}

