% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmose-auxiliar.R
\name{getAverageMortality}
\alias{getAverageMortality}
\title{Computes the average mortality.}
\usage{
getAverageMortality(x, stage = "adults", freq = 12)
}
\arguments{
\item{x}{Mortality dataframe}

\item{stage}{Stage ("adults", etc.)}

\item{freq}{Time frequency (months?)}
}
\value{
An array
}
\description{
It computes the mean mortality, which
is multiplied by the frequency.
}
\examples{
{
dirin = system.file("extdata", package="osmose")
outdir = paste(dirin, "/outputs", sep="")
data = read_osmose(outdir)
mortality_df = data$global$mortality
mort = getAverageMortality(mortality_df, stage="juveniles", freq=12)
}
}
