% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmose-auxiliar.R
\name{getMortality}
\alias{getMortality}
\title{Get the total mortality rate.}
\usage{
getMortality(x, stage = "adults", type = "total")
}
\arguments{
\item{x}{Mortality dataframe}

\item{stage}{Stage ("adults", etc.)}

\item{type}{Mortality type ("pred", "starv", "other", "out", "total"). 
The latter is computed as the sum of all mortality types}
}
\value{
A mortality array
}
\description{
Get the total mortality rate.
}
\examples{
{
dirin = system.file("extdata", package="osmose")
outdir = paste(dirin, "/outputs", sep="")
data = read_osmose(outdir)
mortality_df = data$global$mortality
mort = getMortality(mortality_df, stage="juveniles", type="total")
}
}
