% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmose-main.R
\name{read_osmose}
\alias{read_osmose}
\alias{osmose2R}
\title{Read OSMOSE outputs into an R object}
\usage{
read_osmose(path = NULL, version = "v3r2", species.names = NULL, ...)
}
\arguments{
\item{path}{Path to the directory containing OSMOSE outputs.}

\item{version}{OSMOSE version used to run the model.}

\item{species.names}{Display names for species, overwrite the species names
provided to the OSMOSE model. Used for plots and summaries.}

\item{...}{Additional arguments}
}
\description{
This function create object of class \code{osmose} with the 
outputs from OSMOSE in the \code{path} folder.
}
\details{
A list of class \code{osmose} is created, individual elements can be
extracted using the function \code{getVar}.
}
\examples{
{
  outdir = system.file("extdata", "outputs/", package="osmose")
  read_osmose(outdir)
}
}
\author{
Ricardo Oliveros-Ramos

Laure Velez
}
