% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-osm-groups.R
\name{add_osm_groups}
\alias{add_osm_groups}
\title{add_osm_groups}
\usage{
add_osm_groups(map, obj, groups, cols, bg, make_hull = FALSE, boundary = -1,
  size, shape, borderWidth, colmat = FALSE, rotate)
}
\arguments{
\item{map}{A \code{ggplot2} object to which the grouped objects are to be
added.}

\item{obj}{An \code{sp} \code{SpatialPointsDataFrame},
\code{SpatialPolygonsDataFrame}, or \code{SpatialLinesDataFrame} (list of
polygons or lines) returned by \code{\link{extract_osm_objects}}.}

\item{groups}{A list of spatial points objects, each of which contains the
coordinates of points defining one group.}

\item{cols}{Either a vector of >= 4 colours passed to \code{colour_mat} (if
\code{colmat=T}) to arrange as a 2-D map of visually distinct colours
(default uses \code{rainbow} colours), or (if \code{colmat=F}), a vector of
the same length as groups specifying individual colours for each.}

\item{bg}{If given, then any objects not within groups are coloured this
colour, otherwise (if not given) they are assigned to nearest group and
coloured accordingly (\code{boundary} has no effect in this latter case).}

\item{make_hull}{Either a single boolean value or a vector of same length as
groups specifying whether convex hulls should be constructed around all
groups (\code{TRUE}), or whether the group already defines a hull (convex or
otherwise; \code{FALSE}).}

\item{boundary}{(negative, 0, positive) values define whether the boundary of
groups should (exclude, bisect, include) objects which straddle the precise
boundary. (Has no effect if \code{bg} is given).}

\item{size}{Size argument passed to \code{ggplot2} (polygon, path, point)
functions: determines width of lines for (polygon, line), and sizes of
points.  Respective defaults are (0, 0.5, 0.5).}

\item{shape}{Shape of points or lines (the latter passed as \code{linetype});
see \code{?ggplot2::shape}.}

\item{borderWidth}{If given, draws convex hull borders around entire groups
in same colours as groups (try values around 1-2).}

\item{colmat}{If \code{TRUE} generates colours according to
\code{colour_mat}, otherwise the colours of groups are specified directly by
the vector of \code{cols}.}

\item{rotate}{Passed to \code{colour_mat} to rotate colours by the specified
number of degrees clockwise.}
}
\value{
Modified version of \code{map} with groups added.
}
\description{
Plots spatially distinct groups of OSM objects in different colours.
}
\section{Note}{

Any group that is entirely contained within any other group is assumed to
represent a hole, such that points internal to the smaller contained group
are *excluded* from the group, while those outside the smaller yet inside the
bigger group are included.
}
\examples{
bbox <- get_bbox (c (-0.13, 51.5, -0.11, 51.52))
# Download data using 'extract_osm_objects'
\dontrun{
dat_HP <- extract_osm_objects (key='highway', value='primary', bbox=bbox)
dat_T <- extract_osm_objects (key='tree', bbox=bbox)
dat_BNR <- extract_osm_objects (key='building', value='!residential',
bbox=bbox)
}
# These data are also provided in
dat_HP <- london$dat_HP
dat_T <- london$dat_T
dat_BNR <- london$dat_BNR

# Define a function to easily generate a basemap
bmap <- function ()
{
    map <- osm_basemap (bbox=bbox, bg="gray20")
    map <- add_osm_objects (map, dat_HP, col="gray70", size=1)
    add_osm_objects (map, dat_T, col="green")
}

# Highlight a single region using all objects lying partially inside the
# boundary (via the boundary=1 argument)
pts <- sp::SpatialPoints (cbind (c (-0.115, -0.125, -0.125, -0.115),
                                 c (51.505, 51.505, 51.515, 51.515)))
\dontrun{
dat_H <- extract_osm_objects (key='highway', bbox=bbox) # all highways
map <- bmap ()
map <- add_osm_groups (map, dat_BNR, groups=pts, cols="gray90",
                       bg="gray40", boundary=1)
map <- add_osm_groups (map, dat_H, groups=pts, cols="gray80",
                       bg="gray30", boundary=1)
print_osm_map (map)
}

# Generate random points to serve as group centres
set.seed (2)
ngroups <- 6
x <- bbox [1,1] + runif (ngroups) * diff (bbox [1,])
y <- bbox [2,1] + runif (ngroups) * diff (bbox [2,])
groups <- cbind (x, y)
groups <- apply (groups, 1, function (i) 
              sp::SpatialPoints (matrix (i, nrow=1, ncol=2)))
# plot a basemap and add groups
map <- bmap ()
cols <- rainbow (length (groups))
\dontrun{
map <- add_osm_groups (map, obj=london$dat_BNR, group=groups, cols=cols)
cols <- adjust_colours (cols, -0.2)
map <- add_osm_groups (map, obj=london$dat_H, groups=groups, cols=cols)
print_osm_map (map)

# Highlight convex hulls containing groups:
map <- bmap ()
map <- add_osm_groups (map, obj=london$dat_BNR, group=groups, cols=cols,
                       borderWidth=2)
print_osm_map (map)
}
}
\seealso{
\code{\link{colour_mat}}, \code{\link{add_osm_objects}}.
}

