% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm-basemap.R
\name{osm_basemap}
\alias{osm_basemap}
\title{osm_basemap}
\usage{
osm_basemap(bbox, structures, bg = "gray20")
}
\arguments{
\item{bbox}{bounding box (Latitude-longitude range) to be plotted.  A 2-by-2
matrix of 4 elements with columns of min and max values, and rows of x and y
values.}

\item{structures}{Data frame returned by \code{\link{osm_structures}} used
here to specify background colour of plot; if missing, the colour is
specified by \code{bg}.}

\item{bg}{Background colour of map (default = \code{gray20}) only if
\code{structs} not given).}
}
\value{
A \code{ggplot2} object containing the base \code{map}.
}
\description{
Generates a base OSM plot ready for polygon, line, and point objects to be
overlain with \code{\link{add_osm_objects}}.
}
\examples{
bbox <- get_bbox (c (-0.13, 51.5, -0.11, 51.52))
map <- osm_basemap (bbox = bbox, bg = 'gray20')
map <- add_osm_objects (map, london$dat_BNR, col = 'gray40') 
print_osm_map (map)
}
\seealso{
\code{\link{add_osm_objects}}, \code{\link{make_osm_map}}.
}
