% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studyVariants.R
\name{studyVariants}
\alias{studyVariants}
\title{Retrieves all variants for a study.}
\usage{
studyVariants(study_id)
}
\arguments{
\item{study_id}{Character: Study ID(s) generated by Open Targets Genetics (e.g GCST90002357).}
}
\value{
Returns a list of two data frames.

the first data frame (tibble format) includes the loci data frame with following data structure:
\itemize{
  \item{\code{variant.id}:} \emph{Character}. Variant ID.
  \item{\code{pval}:} \emph{Numeric}. P-value.
  \item{\code{variant.nearestCodingGene.symbol}:} \emph{Character}. Symbol of the nearest coding gene to the variant.
  \item{\code{variant.rsId}:} \emph{Character}. Variant rsID.
  \item{\code{variant.chromosome}:} \emph{Character}. Chromosome of the variant.
  \item{\code{variant.position}:} \emph{Integer}. Position of the variant.
  \item{\code{variant.nearestCodingGeneDistance}:} \emph{Integer}. Distance to the nearest coding gene.
  \item{\code{credibleSetSize}:} \emph{Integer}. Size of the credible set.
  \item{\code{ldSetSize}:} \emph{Integer}. Size of the LD set.
  \item{\code{oddsRatio}:} \emph{Numeric}. Odds ratio.
  \item{\code{beta}:} \emph{Numeric}. Beta value.
}

The second data frame includes gene information with following data structure:
\itemize{
  \item{\code{score}:} \emph{Numeric}. Gene score.
  \item{\code{gene.id}:} \emph{Character}. Gene ID.
  \item{\code{gene.symbol}:} \emph{Character}. Gene symbol.
}
}
\description{
For an input study ID, this function returns information of all variants across associated loci. The output also includes
 information about the associated genes within the each loci.
}
\examples{
\dontrun{
result <- studyVariants(study_id = "GCST003155")
}
}
