% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPSClient.R
\docType{class}
\name{WPSClient}
\alias{WPSClient}
\title{WPSClient}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing an OGC
Web Processing Service.
}
\description{
WPSClient
}
\section{Methods}{

\describe{
 \item{\code{new(url, serviceVersion, user, pwd, logger)}}{
   This method is used to instantiate a WPSClient with the \code{url} of the
   OGC service. Authentication is supported using basic auth (using \code{user}/\code{pwd} arguments), 
   bearer token (using \code{token} argument), or custom (using \code{headers} argument). By default, the \code{logger}
   argument will be set to \code{NULL} (no logger). This argument accepts two possible 
   values: \code{INFO}: to print only \pkg{ows4R} logs, \code{DEBUG}: to print more verbose logs
 }
 \item{\code{getCapabilities()}}{
   Get service capabilities. Inherited from OWS Client
 }
 \item{\code{reloadCapabilities()}}{
   Reload service capabilities
 }
 \item{\code{getProcesses(pretty, full)}}{
   Return the list of processes offered by the service capabilities. \code{pretty} allows to control
   the type output. If \code{TRUE}, a \code{data.frame} will be returned. When prettified output, it
   is also possible to get a 'full' description of the process by setting \code{full = TRUE} in which 
   case a the WPS client will request a process description (with more information about the process) for
   each process listed in the capabilities.
 }
 \item{\code{describeProcess(identifier)}}{
   Get the description of a process, given its \code{identifier}, returning an object of class \code{WPSProcessDescription}
 }
 \item{\code{execute(identifier, dataInputs, responseForm, storeExecuteResponse, lineage, status,
                     update, updateInterval)}}{
   Execute a process, given its \code{identifier}
 }
}
}

\examples{
\donttest{
   #example based on a WPS endpoint responding at http://localhost:8080/geoserver/wps
   wps <- WPSClient$new("http://localhost:8080/geoserver/wps", serviceVersion = "1.0.0")
   
   #get capabilities
   caps <- wps$getCapabilities()
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{OGC}
\keyword{Process}
\keyword{Processing}
\keyword{WPS}
