% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statmap.R
\name{Statmap}
\alias{Statmap}
\title{Create Statistical Parametric Mapping (SPM)}
\usage{
Statmap(copes, alternative = "two.sided", path = getwd(), 
name = "map", Pmap = FALSE, mask = NULL)
}
\arguments{
\item{copes}{list of NIfTI file. The list of copes, i.e., constrasts maps, one for each subject used to compute the statistical tests.}

\item{alternative}{character string. It refers to the alternative hypothesis, must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"lower"}.}

\item{path}{character string. Path to save the NIfTI file. The path does not must end with \code{/}.}

\item{name}{character string. The name of the map NIfTI file that will be used.}

\item{Pmap}{Boolean value. If \code{TRUE} the SPM of the pvalues is returned. Default @FALSE.}

\item{mask}{NIfTI file or character string. 3D array of logical values (i.e. \code{TRUE/FALSE} in/out of the brain). 
Alternatively it may be a (character) NIfTI file name. If \code{mask=NULL}, it is assumed that non of the voxels have to be excluded.}
}
\value{
Save the Statistical Parametric Mapping Nifti file in \code{path} with name specified in \code{name}.
}
\description{
It creates the statistical parametric mapping in NIfTI format.
}
\examples{
\dontrun{
library(fMRIdata)
data(Auditory_copes)
data(Auditory_mask)
Statmap(copes = Auditory_copes, mask = Auditory_mask)
}
}
\author{
Angela Andreella

Angela Andreella
}
