% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappingFunctions.R
\name{LD.load.csv}
\alias{LD.load.csv}
\title{Load a .csv based log file into a \code{dataLoader} object}
\usage{
LD.load.csv(loader.obj, nomeFile, IDName, EVENTName, quote = "\\"",
  sep = ",")
}
\arguments{
\item{loader.obj}{a \code{dataLoader} object to load the data in}

\item{nomeFile}{the path of the .csv file}

\item{IDName}{the name of the column which contains the PATIENT ID}

\item{EVENTName}{the name of the column which contains the EVENTS}

\item{quote}{a quoting character ( default = '"' )}

\item{sep}{the separator ( default = ',' )}
}
\description{
This function wraps the \code{dataLoader::load.csv( ... ) } method and returns nothing but the object passed as \code{loader.obj} is loaded with the given .csv file content
}
\examples{
\dontrun{ 
# Instantiate a'dataLoader' object
obj<- LD.builder()

# load a .csv
LD.load.csv(loader.obj = obj,nomeFile = "../csv/rectalCancer.csv",
   IDName = "ID_PATIENT",EVENTName = "EVNT")
} 
}

