% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataLoader.R
\name{dataLoader}
\alias{dataLoader}
\title{load csv based log files}
\usage{
dataLoader()
}
\description{
A loader for csv based log files. It also calculates the footprint table, transition matrix probabilities, and presents data in different shapes. The public methods are:
             \itemize{
             \item \code{dataLoader() } the costructor
             \item \code{load.csv( ... ) } loads the a csv file into the \code{dataLoader} object
             \item \code{getData() } returns the loaded data
             }
             There are two ways to use this class: directly using the methods previously 
             listed or via wrapping functions (called LD.<method name>). In the examples section you will find an example of both.
}
\examples{
\dontrun{
# -----------------------------------------------
#  USING THE METHODS of the class
# -----------------------------------------------
obj.L<-dataLoader();   # create a Loader

# Load a .csv using "DES" and "ID" as column names to indeicate events 
# and Patient's ID
obj.L$loader(nomeFile = "./otherFiles/test_02.csv",IDName = "ID",
EVENTName = "DES")

# print the footprint table 
res<- obj.L$getData()
print(res$footprint)


# -----------------------------------------------
#  USING THE WRAPPER Functions
# -----------------------------------------------
# Instantiate a loader
obj.LD<-LD.builder()

# Load a CSV into the loader
LD.load.csv(loader.obj = obj.LD ,nomeFile = "./otherFiles/test_02.csv",
IDName = "ID",EVENTName = "DES")

# Instantiate a PM model
obj.PM <-PM.builder(kindOfObject = "alphaAlgorithm")

# get the data
res = LD.getData(loader.obj = obj.LD)

# print the footprint table
print(res$footprint)
}
}

