% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pRecipe.R
\name{import_full_data}
\alias{import_full_data}
\title{Read precipitation data.table from database}
\usage{
import_full_data(name, database_folder_path = "./data/database")
}
\arguments{
\item{name}{a character string with the name of the desired data set. Suitable options are:
\itemize{
\item{"all" for all of the below listed data sets,}
\item{"20cr" for 20CR v3,}
\item{"cmap" for CMAP standard version,}
\item{"cmorph" for CMORPH,}
\item{"cpc" for CPC-Global,}
\item{"cru_ts" for CRU_TS v4.05,}
\item{"ghcn" for GHCN-M v2}
\item{"gpcc" for GPCC v2018,}
\item{"gpcp" for GPCP v2.3,}
\item{"gpm_imergm" for GPM IMERGM Final v06,}
\item{"ncep" for NCEP/NCAR,}
\item{"ncep_doe" for NCEP/DOE,}
\item{"persiann_cdr" for PERSIANN CDR,}
\item{"precl" for PRECL,}
\item{"trmm_3b43" for TRMM 3B43 v7,}
\item{"udel" for UDEL v501.}
}}

\item{database_folder_path}{a character string with the path where the "database" folder is located.}
}
\value{
a data.table with the requested precipitation data sets.
}
\description{
The function \code{import_full_data} imports the requested data sets.
}
\examples{
\dontrun{
x <- import_full_data("all", tempdir())
x <- import_full_data(c("cru_ts", "cpc", "ghcn", "gpcp"), tempdir())
x <- import_full_data(c("gpm_imergm", "trmm_3b43"), tempdir())
}
}
