% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packageRankTime.R
\name{packageRankTime}
\alias{packageRankTime}
\title{Package download counts and rank percentiles (longitudinal).}
\usage{
packageRankTime(packages = "HistData", when = "last-month",
  sample.pct = 5, multi.core = TRUE)
}
\arguments{
\item{packages}{Character. Character. Vector of package name(s).}

\item{when}{Character. "last-month" or "last-week".}

\item{sample.pct}{Numeric. Percent of packages to sample.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores to use. Note that due to performance considerations, the number of cores defaults to one on Windows.}
}
\description{
Temporal pattern over last week or month.
}
\note{
Most useful with plot() method.
}
\examples{
\donttest{
plot(packageRankTime(packages = "HistData", when = "last-week"))
plot(packageRankTime(packages = c("Rcpp", "rlang", "data.table"), when = "last-month"))
}
}
