% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/description.R
\name{set_desc_url}
\alias{set_desc_url}
\title{Set a \file{DESCRIPTION} File's \acronym{URL} Field}
\usage{
set_desc_url(
  url,
  path = ".",
  normalize = TRUE,
  overwrite = FALSE,
  do_commit = is_force(),
  do_remind = !isTRUE(getOption("packager")[["force"]]),
  verbose = getOption("packager")[["verbose"]]
)
}
\arguments{
\item{url}{A character string giving the \acronym{URL} to set or add in
\file{DESCRIPTION}.}

\item{path}{Path to the \file{DESCRIPTION} file, see
\code{\link[desc:desc_get_urls]{desc::desc_get_urls}}.}

\item{normalize}{See \code{\link[desc:desc_set_urls]{desc::desc_set_urls}}.}

\item{overwrite}{Set (overwrite) the \acronym{URL} field in
\file{DESCRIPTION}
instead
adding the \acronym{URL} given to the \acronym{URL} field in
\file{DESCRIPTION}?}

\item{do_commit}{Commit the updated \file{DESCRIPTION}?}

\item{do_remind}{Write a reminder into the package's \file{TODO.md}?}

\item{verbose}{Be verbose?}
}
\value{
\code{\link[=invisible]{Invisibly} \link[=logical]{TRUE}}
}
\description{
I frequently forget to add an \acronym{URL} to my packages'
\file{DESCRIPTION} files,
and when I do not, I often forget to check that the \acronym{URL} is valid,
respectively the one I want. \cr
So this is a wrapper to functions from \pkg{desc} and \pkg{gert} and
messaging and/or adding
a reminder to file \code{TODO.md}.
}
\examples{
path <- file.path(tempdir(), "myPackage")
unlink(path, recursive = TRUE)
usethis::create_package(path, open = FALSE)
gert::git_init(path)
gert::git_add(repo = path, files = ".")
signature <- gert::git_signature(name = "Foobar", email = "no@where.com")
gert::git_commit(repo = path, message = "Initial commit",
                 author = signature, committer = signature)
url <- provide_gitlab_url(path = path)
set_desc_url(url, path = path)
grep("URL:", readLines(file.path(path, "DESCRIPTION")), value = TRUE)
readLines(file.path(path, "TODO.md"))
}
\keyword{internal}
