% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{old_pageviews}
\alias{old_pageviews}
\title{Retrieve Legacy Pageview Counts}
\usage{
old_pageviews(
  project = "en.wikipedia",
  platform = "all",
  granularity = "daily",
  start = "2013100100",
  end = "2015100100",
  reformat = TRUE,
  ...
)
}
\arguments{
\item{project}{the name of the project, structured as \code{[language_code].[project]}
(see the default).}

\item{platform}{The platform the pageviews came from; one or more of  "all", "desktop" or "mobile".
Set to "all" by default.}

\item{granularity}{the granularity of data to return; do you want hourly, daily or monthly counts? Set
to "daily" by default.}

\item{start}{the start \code{YYYYMMDDHH} of the range you want to cover. This can be
easily grabbed from R date/time objects using \code{\link{pageview_timestamps}}}

\item{end}{the end \code{YYYYMMDDHH} of the range you want to cover. NULL by default, meaning
that it returns 1 day/hour of data (depending on the value passed to \code{granularity}).}

\item{reformat}{Whether to reformat the results as a \code{\link{data.frame}} or not. TRUE by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
This retrieves per-project pageview counts from January 2008
to July 2016. These counts are calculated using the 'legacy' (read: old)
model, which overcounts due to its inclusion of web-crawlers and
similar automata.
}
\examples{
# Basic call
enwiki_2013_2015_old <- old_pageviews()

# Break it down to hourly
old_enwiki_hourly <- old_pageviews(granularity = "hourly", end = "2013110100")

}
\seealso{
\code{\link{top_articles}} for the top articles per project in a given date range,
\code{\link{project_pageviews}} for per-project pageviews under the new definition,
and \code{\link{article_pageviews}} for per-article pageviews.
}
