% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system-requirements.R
\name{local_system_requirements}
\alias{local_system_requirements}
\alias{pkg_system_requirements}
\title{Query system requirements}
\usage{
local_system_requirements(
  os = NULL,
  os_release = NULL,
  root = ".",
  execute = FALSE,
  sudo = execute,
  echo = FALSE
)

pkg_system_requirements(
  package,
  os = NULL,
  os_release = NULL,
  execute = FALSE,
  sudo = execute,
  echo = FALSE
)
}
\arguments{
\item{os, os_release}{The operating system and operating system release
version, e.g. "ubuntu", "debian", "centos", "redhat". See
\url{https://github.com/rstudio/r-system-requirements#operating-systems} for
all full list of supported operating systems.

If \code{NULL}, the default, these will be looked up using \code{\link[distro:distro]{distro::distro()}}.}

\item{root}{Path to the package tree.}

\item{execute, sudo}{If \code{execute} is \code{TRUE}, pak will execute the system
commands (if any). If \code{sudo} is \code{TRUE}, pak will prepend the commands with
\href{https://en.wikipedia.org/wiki/Sudo}{sudo}.}

\item{echo}{If \code{echo} is \code{TRUE} and \code{execute} is \code{TRUE}, echo the command output.}

\item{package}{Package names to lookup system requirements for.}
}
\value{
A character vector of commands needed to install the system
requirements for the package.
}
\description{
Returns a character vector of commands to run that will install system
requirements for the queried operating system.

\code{local_system_requirements()} queries system requirements for a dev package
(and its dependencies) given its \code{root} path.

\code{pkg_system_requirements()} queries system requirements for existing packages
(and their dependencies).
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
local_system_requirements("ubuntu", "20.04")
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pkg_system_requirements("pak", "ubuntu", "20.04")
pkg_system_requirements("pak", "redhat", "7")
pkg_system_requirements("config", "ubuntu", "20.04") # no sys reqs
pkg_system_requirements("curl", "ubuntu", "20.04")
pkg_system_requirements("git2r", "ubuntu", "20.04")
pkg_system_requirements(c("config", "git2r", "curl"), "ubuntu", "20.04")
# queried packages must exist
pkg_system_requirements("iDontExist", "ubuntu", "20.04")
pkg_system_requirements(c("curl", "iDontExist"), "ubuntu", "20.04")
\dontshow{\}) # examplesIf}
}
