% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{methods}
\alias{methods}
\alias{predict.palasso}
\alias{coef.palasso}
\alias{weights.palasso}
\alias{fitted.palasso}
\alias{residuals.palasso}
\alias{deviance.palasso}
\alias{logLik.palasso}
\alias{summary.palasso}
\title{Methods for class "palasso"}
\usage{
\method{predict}{palasso}(object, newdata, model = "paired",
  s = "lambda.min", max = NULL, ...)

\method{coef}{palasso}(object, model = "paired", s = "lambda.min",
  max = NULL, ...)

\method{weights}{palasso}(object, model = "paired", max = NULL, ...)

\method{fitted}{palasso}(object, model = "paired", s = "lambda.min",
  max = NULL, ...)

\method{residuals}{palasso}(object, model = "paired", s = "lambda.min",
  max = NULL, ...)

\method{deviance}{palasso}(object, model = "paired", max = NULL, ...)

\method{logLik}{palasso}(object, model = "paired", max = NULL, ...)

\method{summary}{palasso}(object, model = "paired", ...)
}
\arguments{
\item{object}{\link[palasso]{palasso} object}

\item{newdata}{covariates\strong{:}
list of matrices, each with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{model}{character \code{"paired"},
or an entry of \code{names(object)}}

\item{s}{penalty parameter\strong{:}
character \code{"lambda.min"} or \code{"lambda.1se"},
positive numeric,
or \code{NULL} (entire sequence)}

\item{max}{maximum number of non-zero coefficients,
positive integer,
or \code{NULL}}

\item{...}{further arguments for
\code{\link[glmnet]{predict.cv.glmnet}},
\code{\link[glmnet]{coef.cv.glmnet}},
or \code{\link[glmnet]{deviance.glmnet}}}
}
\description{
This page lists the main methods for class "palasso".
}
\details{
By default, the function \code{predict} returns
the linear predictor (\code{type="link"}).
Consider predicting the response (\code{type="response"}).
}
\seealso{
Use \link[palasso]{palasso} to fit the paired lasso.
}
