% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexModels.R
\name{opt.GRW.shift}
\alias{opt.GRW.shift}
\title{Fit random walk model with shift(s) in generating parameters}
\usage{
opt.GRW.shift(y, ng = 2, minb = 7, model = 1, pool = TRUE,
  silent = FALSE)
}
\arguments{
\item{y}{a \code{paloeTS} object}

\item{ng}{number of segments in the sequence}

\item{minb}{minimum number of populations in each segment}

\item{model}{numeric, specifies exact evolutionary model; see Details}

\item{pool}{if TRUE, sample variances are substituted with their pooled estimate}

\item{silent}{logical, if TRUE, progress updates are suppressed}
}
\value{
a \code{paleoTSfit} object
}
\description{
Fit random walk model with shift(s) in generating parameters
}
\details{
Fits a model in which a sequence is divided into two or more segments and
trait evolution proceeds as a general random walk, with each segment (potentially)
getting its own generating parameters (\code{mstep}, \code{vstep}). \cr \cr

This function tests for shifts after each population, subject to the
constraint that the number of populations in each segment is always >= \code{minb}. The
shiftpoint yielding the highest log-likelihood is returned as the solution, along with
the log-likelihoods (\code{all.logl} of all tested shift points (\code{GG}). \cr \cr

Different variants of the model can be specified by the \code{model} argument:
\itemize{
\item \code{model = 1:  } \code{mstep} is separate across segments; \code{vstep} is shared
\item \code{model = 2:  } \code{mstep} is shared across segments; \code{vstep} is separate
\item \code{model = 3:  } \code{mstep} is set to zero (unbiased random walk); \code{vstep}
is separate across segments
\item \code{model = 4:  } \code{mstep} and \code{vstep} are both separate across segments
}
}
\examples{
x <- sim.GRW.shift(ns = c(15,15), ms = c(0, 1), vs = c(0.1,0.1))
w.sep <- opt.GRW.shift(x, ng = 2, model = 4)
w.sameVs <- opt.GRW.shift(x, ng = 2, model = 1)
compareModels(w.sep, w.sameVs)
plot(x)
abline(v = x$tt[16], lwd = 3)  # actual shift point
abline(v = x$tt[w.sameVs$par["shift1"]], lty = 3, col = "red", lwd = 2) # inferred shift point
}
\seealso{
\code{\link{sim.GRW.shift}}
}
