% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexModels.R
\name{sim.punc}
\alias{sim.punc}
\title{Simulate a punctuated time-series}
\usage{
sim.punc(ns = c(10, 10), theta = c(0, 1), omega = rep(0,
  length(theta)), nn = rep(30, sum(ns)), tt = 0:(sum(ns) - 1),
  vp = 1)
}
\arguments{
\item{ns}{vector of the number of samples in each segment}

\item{theta}{vector of means, one for each segment}

\item{omega}{vector of variances, one for each segment.}

\item{nn}{vector of sample sizes, one for each population}

\item{tt}{vector of times (ages), one for each population}

\item{vp}{phenotypic variance within each population}
}
\value{
a \code{paleoTS} object with the simulated time-series.
}
\description{
Simulates punctuated trait evolution with punctuations that are rapid relative
to the spacing of samples. In practice, the time-series is divided into two or more
segments, each of which has its own mean and variance.
}
\details{
Segments are separated by punctuations. Population means in the ith segment are
drawn randomly from a normal distribution with a mean equal to ith element of \code{theta}
and variance equal to the ith element of \code{omega}. The magnitudes of punctuations are
determined by the differences in adjacent \code{theta} values.
}
\examples{
x <- sim.punc(ns = c(15, 15), theta = c(0,3), omega = c(0.1, 0.1))
plot(x)
}
\seealso{
\code{\link{fitGpunc}}
}
