% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_geographic_functions.R
\name{pbdb_map_richness}
\alias{pbdb_map_richness}
\title{Plot a raster showing the richness of taxa}
\usage{
pbdb_map_richness(
  data,
  rank = c("species", "genus", "family", "order", "class", "phylum"),
  do_plot = TRUE,
  res = 5,
  col_int = "white",
  col_ocean = "black",
  col_rich = c("light blue", "blue"),
  title = "Taxonomic richness",
  ...
)
}
\arguments{
\item{data}{Input data frame. This data frame is the output of the
\code{\link[=pbdb_occurrences]{pbdb_occurrences()}} function using the argument \code{show = c("coords", "classext")}. See also Details and Examples.}

\item{rank}{Taxon rank for which richness is calculated. The
options are: \code{"species"}, \code{"genus"}, \code{"family"}, \code{"order"},
\code{"class"} or \code{"phylum"}.  The default value is \code{"species"}.}

\item{do_plot}{Logical. If \code{TRUE}, the function produces a plot in
addition to returning a \code{SpatRaster}.}

\item{res}{The resolution of the \code{SpatRaster} object (in decimal
degrees). See \code{\link[terra:dimensions]{terra::res()}}.}

\item{col_int}{The colour of the mainland.}

\item{col_ocean}{The colour of the ocean.}

\item{col_rich}{Two or more colours that are used to generate the
colour gradient showing the richness per cell in the map.}

\item{title}{A title for the plot, to be positioned to the right of
the legend.}

\item{...}{Other parameters. See \code{\link[=par]{par()}} and \code{\link[=map]{map()}}.}
}
\value{
A \code{SpatRaster} object with the richness of the specified
taxon rank per cell. This \code{SpatRaster} object has the resolution
that was specified in the \code{res} argument. The default is \code{res = 5}. Users that wish to work with objects of this type should load
package \code{terra}.
}
\description{
Creates a \code{SpatRaster} object and a plot with richness of
species, genera, families, etc. per cell.
}
\details{
The argument \code{show = c("coords", "classext")} in the
\code{\link[=pbdb_occurrences]{pbdb_occurrences()}} function is required. We recommend the use
of a cairo device (\code{\link[=X11]{X11()}}) for better visualization of the
graphs. See Examples.
}
\examples{
\dontrun{
  data <- pbdb_occurrences(
    limit = 1000, vocab = "pbdb", base_name = "mammalia",
    show = c("classext", "coords")
  )
  X11(width = 13, height = 7.8)
  pbdb_map_richness(data, res = 8, rank = "genus")
  pbdb_map_richness(data, res = 8, rank = "family")
  ## Get the raster object without plotting the map
  pbdb_map_richness(data, res = 8, rank = "family", do_plot = FALSE)
}
}
\seealso{
See \code{\link[=pbdb_occurrences]{pbdb_occurrences()}}, \code{\link[=map]{map()}}, \code{\link[=par]{par()}} and \code{\link[=colors]{colors()}}
help pages.
}
