% Generated by roxygen2 (4.0.1): do not edit by hand
\name{kdffreq}
\alias{kdffreq}
\title{Fire frequency using kernel density}
\usage{
kdffreq(fevent, up = NULL, lo = NULL, bandwidth = NULL, nbboot = NULL,
  alpha = NULL)
}
\arguments{
\item{fevent}{Numeric vector, set of dates}

\item{up}{Numeric, upper age for fire frequnecy calculus}

\item{lo}{Numeric, lower age for fire frequnecy calculus}

\item{bandwidth}{Numeric, bandwidth in years, or character for automatic
bandwidth calculation (e.g. "bw.ucv" for unbiased cross validation) see
\code{\link[stats]{bandwidth}} for details}

\item{nbboot}{Numeric, number of bootstrap replicates}

\item{alpha}{Numeric, confidence interval (default 0.01)}
}
\value{
ff data.frame, with fire frequency, bandwidth and CIs
}
\description{
Computes paleo-fire frequency for a set of fire events using a gaussian
kernel density estimation procedure based on a defined bandwidth (see Mudelsee 2004 for
details). Pseudo-replicated values are used to correct for edge bias, equivalent to
"minimum slope" correction in Mann (2004).
}
\examples{
set.seed(123)
 fevent=c(round(abs(rnorm(20,mean=7,sd=5))*1000),round(abs(rnorm(10,mean=8,sd=1))*1000))

 ff=kdffreq(fevent,bandwidth = 1000, nbboot=10)
}
\author{
O. Blarquez
}
\references{
Mann, M. E. (2004). On smoothing potentially non-stationary
climate time series. Geophysical Research Letters, 31(7). \cr \cr
Mudelsee, M., Börngen, M., Tetzlaff, G., & Grünewald, U. (2004). Extreme floods
in central Europe over the past 500 years: Role of cyclone pathway “Zugstrasse Vb”.
 Journal of Geophysical Research: Atmospheres (1984–2012), 109(D23).
}
\seealso{
\code{\link{plot.kdffreq}}
}

