% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdffreq.R
\name{kdffreq}
\alias{kdffreq}
\title{Fire frequency using kernel density}
\usage{
kdffreq(fevent, up = NULL, lo = NULL, interval = 10,
  bandwidth = NULL, boot = "full", bootper = 0.1, nbboot = NULL,
  alpha = NULL, pseudo = FALSE)
}
\arguments{
\item{fevent}{Numeric vector, set of dates}

\item{up}{Numeric, upper age for fire frequency calculus}

\item{lo}{Numeric, lower age for fire frequency calculus}

\item{interval}{Numeric, interval between two points for fire frequency calculus (default 10 years)}

\item{bandwidth}{Numeric, bandwidth in years, or character for automatic
bandwidth calculation (e.g. "bw.ucv" for unbiased cross validation) see
\code{\link[stats]{bandwidth}} for details}

\item{boot}{Character, "full" or "partial" see @details}

\item{bootper}{Numeric, percentage of fire events randomly added or removed in the "partial" replication procedure (default 0.1)}

\item{nbboot}{Numeric, number of bootstrap replicates}

\item{alpha}{Numeric, confidence interval (default 0.01)}

\item{pseudo}{Logical, apply (TRUE) or not (FALSE) Mann (2004) correction (default=FALSE)}
}
\value{
ff data.frame, with fire frequency, bandwidth and CIs
}
\description{
Computes paleo-fire frequency for a set of fire events (or frequency from other events types, see examples)
using a gaussian kernel density estimation procedure based on a defined bandwidth (see Mudelsee 2004 for
details). Pseudo-replicated values are used to correct for edge bias, equivalent to
"minimum slope" correction in Mann (2004).
}
\details{
By using boot="partial" option (beta!) fire dates are randomly removed or added within a defined percentage (by default between 1 and 10\%
of total number of events) in order to make new series that are then used to calculate ensemble members fire frequencies. This procedure differs slightly from
the full bootstrapp where fire dates are randomly picked with replacement. Theoretically classic bootstrap could result in a sample
where a single fire event date is replicated n times which makes no sense for fires. By randomly removing or adding fire dates the confidence
intervals are narrower and likely better reflect the long term fire regime variablility.
}
\examples{
 \dontrun{
 set.seed(123)
 fevent=c(round(abs(rnorm(20,mean=7,sd=5))*1000),round(abs(rnorm(10,mean=8,sd=1))*1000))
 ff=kdffreq(fevent,bandwidth = 1000, nbboot=10)

 
 # Estimate the frequency of armed conflicts from 1946 to 2014
 # Data from the The Uppsala Conflict Data Program (UCDP) available at: https://www.prio.org

 dat=read.csv('http://ucdp.uu.se/downloads/ucdpprio/ucdp-prio-acd-4-2016.csv')
 res=kdffreq(dat$Year,bandwidth = "bw.ucv", nbboot=1000, up = 1946, lo = 2014, interval=1, pseudo=T)
 plot(res, ylab="# armed conflict/year")
 }
}
\references{
Mann, M. E. (2004). On smoothing potentially non-stationary
climate time series. Geophysical Research Letters, 31(7). \cr \cr
Mudelsee, M., Börngen, M., Tetzlaff, G., & Grünewald, U. (2004). Extreme floods
in central Europe over the past 500 years: Role of cyclone pathway “Zugstrasse Vb”.
 Journal of Geophysical Research: Atmospheres (1984–2012), 109(D23).
}
\seealso{
\code{\link{plot.kdffreq}}
}
\author{
O. Blarquez
}
