% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_results_table.R
\name{$.apa_results_table}
\alias{$.apa_results_table}
\alias{[[.apa_results_table}
\alias{[.apa_results_table}
\title{Extract Parts of an APA Results Table}
\usage{
\method{$}{apa_results_table}(x, name)

\method{[[}{apa_results_table}(x, i, exact = TRUE)

\method{[}{apa_results_table}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{
    object from which to extract element(s) or in which to replace element(s).
  }

\item{name}{
    A literal character string or a \link[base]{name} (possibly \link[base]{backtick}
    quoted).  For extraction, this is normally (see under
    \sQuote{Environments}) partially matched to the \code{\link[base]{names}}
    of the object.
  }

\item{i, j, ...}{Indices specifying elements to extract. See \code{\link[base:Extract]{base::Extract()}} for details.}

\item{exact}{Controls possible partial matching of \code{[[} when
    extracting by a character vector (for most objects, but see under
    \sQuote{Environments}).  The default is no partial matching.  Value
    \code{NA} allows partial matching but issues a warning when it
    occurs.  Value \code{FALSE} allows partial matching without any
    warning.}

\item{drop}{For matrices and arrays.  If \code{TRUE} the result is
    coerced to the lowest possible dimension (see the examples).  This
    only works for extracting elements, not for the replacement.  See
    \code{\link[base]{drop}} for further details.
  }
}
\value{
A (vector of) character values as extracted from an object of class
\code{apa_results_table}.
}
\description{
\emph{These methods are only defined for backward compatibility with older
versions of \pkg{papaja}}. In the past, the column names of\code{apa_results_table}s
were less standardized than they are today. In order to maintain backwards
compatibility, it is still possible to extract columns with the old columns names,
because we here provide \emph{aliased} indexing. Note that aliased indexing will be
defunct in a future release of \pkg{papaja}.
}
