#' @template make-logo
#' @export
make_logo <- function(template = "./inst/assets/logo/parabar-logo.txt", version = c(1, 0, 0)) {
    # Load the ASCII logo.
    logo <- readLines(template)

    # Redirect console output.
    sink("/dev/null")

    # Parse the logo.
    logo <- dput(logo)

    # Remove output redirection.
    sink()

    # Update versioning.
    logo <- gsub("{{major}}", version[1], logo, perl = TRUE)
    logo <- gsub("{{minor}}", version[2], logo, perl = TRUE)
    logo <- gsub("{{patch}}", version[3], logo, perl = TRUE)

    # Condensed version.
    logo <- paste(logo, collapse = "\n")

    return(logo)
}


#' @title
#' The Package Logo
#'
#' @description
#' The logo is generated by [parabar::make_logo()] and displayed on package
#' attach for interactive `R` sessions.
#'
#' @format
#' An object of class `character` containing the `ASCII` logo.
#'
#' @examples
#' print(LOGO)
#'
#' @seealso [parabar::make_logo()]
#'
#' @export
LOGO = ". . . . . . . . . . . . . . . . . . . . . . . . . . .\n.                              _             v0.x.x .\n.                             | |                   .\n.   _ __    __ _  _ __   __ _ | |__    __ _  _ __   .\n.  | '_ \\  / _` || '__| / _` || '_ \\  / _` || '__|  .\n.  | |_) || (_| || |   | (_| || |_) || (_| || |     .\n.  | .__/  \\____||_|    \\____||____/  \\____||_|     .\n.  | |                                              .\n.  |_|                                              .\n.                                                   .\n. . . . . . . . . . . . . . . . . . . . . . . . . . .\n.                         .                         .\n.        https://parabar.mihaiconstantin.com        .\n.                         .                         .\n. . . . . . . . . . . . . . . . . . . . . . . . . . ."

# Add package logo class.
class(LOGO) <- "parabar"

# Add S3 method for properly printing the logo.
#' @export
print.parabar <- function(x, ...) {
    # Print the logo.
    cat(LOGO, sep = "")
}
