% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramGUI.R
\name{simndecay_gen_paramGUI}
\alias{simndecay_gen_paramGUI}
\title{Simulate data}
\usage{
simndecay_gen_paramGUI(
  kinpar,
  tmax,
  deltat,
  specpar = vector(),
  lmin,
  lmax,
  deltal,
  sigma,
  irf = FALSE,
  irfpar = vector(),
  seqmod = FALSE,
  dispmu = FALSE,
  nocolsums = FALSE,
  disptau = FALSE,
  parmu = list(),
  partau = vector(),
  lambdac = 0,
  fullk = FALSE,
  kmat = matrix(),
  jvec = vector(),
  specfun = "gaus",
  nupow = 1,
  irffun = "gaus",
  kinscal = vector(),
  lightregimespec = list(),
  specdisp = FALSE,
  specdisppar = list(),
  parmufunc = "exp",
  specdispindex = list(),
  amplitudes = vector(),
  specref = 0,
  nosiminfo = TRUE
)
}
\arguments{
\item{kinpar}{vector of rate constants}

\item{tmax}{last time point}

\item{deltat}{time step}

\item{specpar}{vector of spectral parameters for location, width, skewness}

\item{lmin}{minimum wavelength (nm)}

\item{lmax}{maximum wavelength (nm)}

\item{deltal}{wavelength step}

\item{sigma}{noise level}

\item{irf}{logical for IRF usage}

\item{irfpar}{vector of IRF parameters for location, width}

\item{seqmod}{logical for sequential model}

\item{dispmu}{logical for dispersion of IRF location mu}

\item{nocolsums}{logical for <TODO>}

\item{disptau}{logical for dispersion of IRF width tau}

\item{parmu}{vector of dispersion parameters for IRF location mu}

\item{partau}{vector of dispersion parameters for IRF width tau}

\item{lambdac}{center wavelength for dispersion}

\item{fullk}{logical for full K matrix}

\item{kmat}{K matrix}

\item{jvec}{input vector}

\item{specfun}{function for spectral shape}

\item{nupow}{power of nu in spectral model}

\item{irffun}{function for IRF}

\item{kinscal}{vector of kinetic scaling parameters}

\item{lightregimespec}{<TODO>}

\item{specdisp}{logical for dispersion parameters of spectral parameters}

\item{specdisppar}{vector of dispersion parameters of spectral parameters}

\item{parmufunc}{<TODO>}

\item{specdispindex}{<TODO>}

\item{amplitudes}{amplitudes of components}

\item{specref}{<TODO>}

\item{nosiminfo}{logical for hiding simulation information}
}
\value{
an object of class 'kin'
}
\description{
Calculates an object of class 'kin'. <TODO>
}
\author{
Katharine M. Mullen

Ivo H. M. van Stokkum
}
