% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_standard_error.R, R/methods_base.R
\name{standard_error}
\alias{standard_error}
\alias{standard_error.default}
\alias{standard_error.factor}
\title{Standard Errors}
\usage{
standard_error(model, ...)

\method{standard_error}{default}(
  model,
  effects = "fixed",
  component = "all",
  vcov = NULL,
  vcov_args = NULL,
  verbose = TRUE,
  ...
)

\method{standard_error}{factor}(model, force = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{model}{A model.}

\item{...}{Arguments passed to or from other methods.}

\item{effects}{Should standard errors for fixed effects (\code{"fixed"}), random
effects (\code{"random"}), or both (\code{"all"}) be returned? Only applies
to mixed models. May be abbreviated. When standard errors for random
effects are requested, for each grouping factor a list of standard errors
(per group level) for random intercepts and slopes is returned.}

\item{component}{Model component for which standard errors should be shown.
See the documentation for your object's class in \code{\link[=model_parameters]{model_parameters()}} or
\code{\link[=p_value]{p_value()}} for further details.}

\item{vcov}{Variance-covariance matrix used to compute uncertainty estimates
(e.g., for robust standard errors). This argument accepts a covariance
matrix, a function which returns a covariance matrix, or a string which
identifies the function to be used to compute the covariance matrix.
\itemize{
\item A covariance matrix
\item A function which returns a covariance matrix (e.g., \code{stats::vcov()})
\item A string which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"},
\code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}
\item Cluster-robust: \code{"CR"}, \code{"CR0"}, \code{"CR1"}, \code{"CR1p"}, \code{"CR1S"},
\code{"CR2"}, \code{"CR3"}. See \code{?clubSandwich::vcovCR}
\item Bootstrap: \code{"BS"}, \code{"xy"}, \code{"residual"}, \code{"wild"}, \code{"mammen"},
\code{"fractional"}, \code{"jackknife"}, \code{"norm"}, \code{"webb"}. See
\code{?sandwich::vcovBS}
\item Other \code{sandwich} package functions: \code{"HAC"}, \code{"PC"}, \code{"CL"}, \code{"OPG"},
\code{"PL"}.
}
}}

\item{vcov_args}{List of arguments to be passed to the function identified by
the \code{vcov} argument. This function is typically supplied by the
\strong{sandwich} or \strong{clubSandwich} packages. Please refer to their
documentation (e.g., \code{?sandwich::vcovHAC}) to see the list of available
arguments. If no estimation type (argument \code{type}) is given, the default
type for \code{"HC"} equals the default from the \strong{sandwich} package; for type
\code{"CR"}, the default is set to \code{"CR3"}.}

\item{verbose}{Toggle warnings and messages.}

\item{force}{Logical, if \code{TRUE}, factors are converted to numerical
values to calculate the standard error, with the lowest level being the
value \code{1} (unless the factor has numeric levels, which are converted
to the corresponding numeric value). By default, \code{NA} is returned for
factors or character vectors.}
}
\value{
A data frame with at least two columns: the parameter names and the
standard errors. Depending on the model, may also include columns for model
components etc.
}
\description{
\code{standard_error()} attempts to return standard errors of model
parameters.
}
\note{
For Bayesian models (from \strong{rstanarm} or \strong{brms}), the standard
error is the SD of the posterior samples.
}
\examples{
\dontshow{if (require("sandwich") && require("clubSandwich")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
model <- lm(Petal.Length ~ Sepal.Length * Species, data = iris)
standard_error(model)

# robust standard errors
standard_error(model, vcov = "HC3")

# cluster-robust standard errors
standard_error(model,
  vcov = "vcovCL",
  vcov_args = list(cluster = iris$Species)
)
\dontshow{\}) # examplesIf}
}
