% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters-package.R
\docType{package}
\name{parameters-package}
\alias{parameters-package}
\title{parameters: Extracting, Computing and Exploring the Parameters of Statistical Models using R}
\description{
\strong{parameters}' primary goal is to provide utilities for processing the
parameters of various statistical models (see \href{https://easystats.github.io/insight/}{here}
for a list of supported models). Beyond computing \emph{p-values}, \emph{CIs},
\emph{Bayesian indices} and other measures for a wide variety of models, this
package implements features like \emph{bootstrapping} of parameters and models,
\emph{feature reduction} (feature extraction and variable selection), or tools for
data reduction like functions to perform cluster, factor or principal
component analysis.

Another important goal of the \strong{parameters} package is to facilitate and
streamline the process of reporting results of statistical models, which
includes the easy and intuitive calculation of standardized estimates or
robust standard errors and p-values. \strong{parameters} therefor offers a
simple and unified syntax to process a large variety of (model) objects
from many different packages.

References: Lüdecke et al. (2020) \doi{10.21105/joss.02445}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://easystats.github.io/parameters/}
  \item Report bugs at \url{https://github.com/easystats/parameters/issues}
}

}
\author{
\strong{Maintainer}: Daniel Lüdecke \email{d.luedecke@uke.de} (\href{https://orcid.org/0000-0002-8895-3206}{ORCID})

Authors:
\itemize{
  \item Dominique Makowski \email{dom.makowski@gmail.com} (\href{https://orcid.org/0000-0001-5375-9967}{ORCID})
  \item Mattan S. Ben-Shachar \email{matanshm@post.bgu.ac.il} (\href{https://orcid.org/0000-0002-4287-4801}{ORCID})
  \item Indrajeet Patil \email{patilindrajeet.science@gmail.com} (\href{https://orcid.org/0000-0003-1995-6531}{ORCID})
  \item Søren Højsgaard \email{sorenh@math.aau.dk}
  \item Brenton M. Wiernik \email{brenton@wiernik.org} (\href{https://orcid.org/0000-0001-9560-6336}{ORCID})
}

Other contributors:
\itemize{
  \item Zen J. Lau \email{zenjuen.lau@ntu.edu.sg} [contributor]
  \item Vincent Arel-Bundock \email{vincent.arel-bundock@umontreal.ca} (\href{https://orcid.org/0000-0003-2042-7063}{ORCID}) [contributor]
  \item Jeffrey Girard \email{me@jmgirard.com} (\href{https://orcid.org/0000-0002-7359-3746}{ORCID}) [contributor]
  \item Christina Maimone \email{christina.maimone@northwestern.edu} [reviewer]
  \item Niels Ohlsen [reviewer]
  \item Douglas Ezra Morrison \email{dmorrison01@ucla.edu} (\href{https://orcid.org/0000-0002-7195-830X}{ORCID}) [contributor]
  \item Joseph Luchman \email{jluchman@gmail.com} (\href{https://orcid.org/0000-0002-8886-9717}{ORCID}) [contributor]
}

}
\keyword{internal}
