% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_levene.R
\name{residual_levene}
\alias{residual_levene}
\title{Compare regression residual standard deviation across multiple models.}
\usage{
residual_levene(model_list, model_names = NULL)
}
\arguments{
\item{model_list}{A list of regression models.}

\item{model_names}{A list of names for the regression models (default is
\code{NULL}).}
}
\value{
Numeric vector of Levene test results. This includes an F-statistic,
 numerator  degrees of freedom, denominator degrees of freedom, and the
 associated p-value.
}
\description{
Compare regression residual standard deviation across multiple \code{lm}
models using Levene's test.
}
\details{
Levene's test is often suggested as a diagnostic check for homoskedasticity in
ANOVA analyses. This function works for linear models (\code{\link{lm}})
only.
}
\examples{
 states = as.data.frame(state.x77)

 m1 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='Northeast')
 m2 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='South')
 m3 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='North Central')
 m4 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='West')

 mList = list(m1, m2, m3, m4)

 residual_levene(model_list = mList)

}
