% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examineKinships.R
\name{examineKinships}
\alias{examineKinships}
\title{Check pedigree for relationship errors}
\usage{
examineKinships(x, who = "all", interfam = c("founders", "none", "all"),
  makeplot = T, pch = 4, ...)
}
\arguments{
\item{x}{A \code{\link{linkdat}} object, or a list of such.}

\item{who}{A character vector of one or more of the words 'parents',
'siblings', 'hugs' (= halfsibs/uncles/grandparents), 'cousins' and 'unrelated'. 
Two additional single-word values are possible: 'all' (all of the above, plus 'other') 
and 'close' (= 'parents', 'siblings', 'hugs', 'cousins').}

\item{interfam}{A character; either 'founders', 'none' or 'all', indicating
which interfamiliar pairs of individuals should be included. Only relevant
if \code{x} is a list of several \code{linkdat} objects.}

\item{makeplot}{A logical.}

\item{pch}{Plotting symbol (default: cross).}

\item{\dots}{Other plot arguments passed on to \code{\link{showInTriangle}}.}
}
\value{
A list of data.frames (one for each relation category) with IBD estimates.
}
\description{
This function provides a convenient way to check for pedigree errors in a 
linkage project or other situations where marker data is available for several 
members. The function calls \code{\link{IBDestimate}} to estimate IBD coefficients 
for all indicated pairs of pedigree members and produces a color-coded plot where wrong
relationships are easy to spot.
}
\examples{

x = cousinsPed(1)
x = simpleSim(x, 500, alleles=1:2)
examineKinships(x)

# Pretend we didn't know the brothers (3 and 6) were related
x1 = branch(x, 3)
x2 = branch(x, 6)
x2$famid = 2

# Notice the error: An 'unrelated' dot close to the sibling point
examineKinships(list(x1, x2))

}
\seealso{
\code{\link{IBDestimate}}, \code{\link{IBDtriangle}}, \code{\link{showInTriangle}}
}
\author{
Magnus Dehli Vigeland
}
