% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iff_blocks.R
\name{iff-blocks}
\alias{iff-blocks}
\alias{pd_is_iff}
\alias{pd_is_iff_block}
\alias{pd_all_iff_ids}
\alias{pd_all_iff_block_ids}
\alias{pd_is_tagged_iff_block}
\title{IFF Blocks}
\usage{
pd_is_iff(id, pd, allow.short = TRUE, .check = TRUE)

pd_is_iff_block(id, pd, allow.short = TRUE, .check = TRUE)

pd_all_iff_ids(pd = get("pd", parent.frame()), ...)

pd_all_iff_block_ids(pd, root.only = TRUE, ignore.groups = FALSE, ...)

pd_is_tagged_iff_block(id, pd, tag, doc.only = TRUE, ...,
  .check = TRUE)
}
\arguments{
\item{id}{id of the expression of interest}

\item{pd}{The \code{\link{parse-data}} information}

\item{allow.short}{if \code{if(F)} should be considered an IFF block.}

\item{.check}{Perform checks for input validation?}

\item{...}{passed along.}

\item{root.only}{only root blocks(\code{TRUE}) or all block (\code{FALSE})}

\item{ignore.groups}{Ignore code grouping}

\item{tag}{The tag to consider.}

\item{doc.only}{Should comments be restricted to documentation style
comments only?}
}
\description{
IFF is short for \code{if(FALSE)\{#@tag ...} blocks.
These block can contain development, testing, or example code
that can be extracted into documentation or other files.
}
\details{
Here are some examples:
\itemize{
\item \code{if(FALSE)\{#' @test ...} Is valid and tags the block as a test.
\item \code{if(FALSE)\{#@test ...} Is valid and tags the block as a test.
Note here that we are using the \code{#@} tag
comment.
\item \code{if(FALSE)\{# @test ...} Is valid only if \code{doc.only==FALSE}.
\item \code{if(FALSE)#@test ...}
}
}
\section{Functions}{
\itemize{
\item \code{pd_is_iff}: This function tests if an expression id is the root of an
\code{if(FALSE)} statement, differs from \code{pd_is_iff_block}
in that it will return TRUE even if the conditional statement
is not a formal bracketed block \code{{...}}.

\item \code{pd_is_iff_block}: Tests if an expression id is the root of an
\code{if(FALSE)} block statement, differs from \code{pd_is_iff}
in that in addition to it being an \code{if(FALSE)} expression
the conditional branch of the logic must be a braced block
of code.  E.g. if given the id corresponding to
\code{if(FALSE){...}}, both \code{pd_is_iff()} and \code{pd_is_iff_block()}
would return TRUE while for \code{if(FALSE)do_somthing()}
\code{pd_is_iff()} would return TRUE but \code{pd_is_iff_block()} would
return FALSE because the expression is not a 'block' statement.

\item \code{pd_all_iff_ids}: Get all ids corresponding to IFF expressions.

\item \code{pd_all_iff_block_ids}: Get all ids corresponding to IFF block

\item \code{pd_is_tagged_iff_block}: Test if a block if both an IFF block statement and is tagged.
To tag an IFF block the first pared element must be a comment that contains
an '@' tag to denote a special block. The comment on the same line as the
opening brace or on any subsequent line but cannot be preceded by any other
statement.
}}

